/*
 * Decompiled with CFR 0.152.
 */
package com.modvane.hologenica.block.entity;

import com.modvane.hologenica.block.entity.NeurocellBlockEntity;
import com.modvane.hologenica.item.BioscannerItem;
import com.modvane.hologenica.registry.HologenicaBlockEntities;
import com.modvane.hologenica.util.NeurocellConnector;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class ImprinterBlockEntity
extends BlockEntity {
    private int imprintProgress = 0;
    private boolean isImprinting = false;
    private String playerName = "";

    public ImprinterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)HologenicaBlockEntities.IMPRINTER.get(), pos, state);
    }

    public void tick() {
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        LivingEntity entity = this.findEntityOnImprinter();
        if (entity == null) {
            this.resetImprinting();
            return;
        }
        NeurocellBlockEntity neurocell = this.findConnectedNeurocellWithEmptyBioscanner();
        if (neurocell == null) {
            this.resetImprinting();
            return;
        }
        this.pullEntityToCenter(entity);
        this.processImprinting(entity, neurocell);
    }

    @Nullable
    private LivingEntity findEntityOnImprinter() {
        if (this.level == null) {
            return null;
        }
        AABB checkBox = new AABB((double)this.worldPosition.getX(), (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ(), (double)(this.worldPosition.getX() + 1), (double)this.worldPosition.getY() + 3.0, (double)(this.worldPosition.getZ() + 1));
        List entities = this.level.getEntitiesOfClass(LivingEntity.class, checkBox);
        return entities.isEmpty() ? null : (LivingEntity)entities.get(0);
    }

    private void pullEntityToCenter(LivingEntity entity) {
        double centerX = (double)this.worldPosition.getX() + 0.5;
        double centerZ = (double)this.worldPosition.getZ() + 0.5;
        double targetY = (double)this.worldPosition.getY() + 0.5;
        double dx = centerX - entity.getX();
        double dz = centerZ - entity.getZ();
        double dy = targetY - entity.getY();
        entity.setDeltaMovement(dx * 0.1, dy * 0.1, dz * 0.1);
        entity.hurtMarked = true;
    }

    private void processImprinting(LivingEntity entity, NeurocellBlockEntity neurocell) {
        if (!this.isImprinting) {
            this.startImprinting(entity);
        }
        ++this.imprintProgress;
        this.spawnImprintingEffects(entity);
        if (this.imprintProgress >= 100) {
            this.completeImprinting(entity, neurocell);
        }
    }

    private void startImprinting(LivingEntity entity) {
        this.isImprinting = true;
        this.imprintProgress = 0;
        this.playerName = entity.getDisplayName().getString();
        this.setChanged();
    }

    private void resetImprinting() {
        if (this.isImprinting) {
            this.isImprinting = false;
            this.imprintProgress = 0;
            this.setChanged();
        }
    }

    private void spawnImprintingEffects(LivingEntity entity) {
        double y;
        double z;
        double x;
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (this.imprintProgress % 2 == 0) {
            double angle = (double)this.imprintProgress * 0.2 % (Math.PI * 2);
            x = entity.getX() + Math.cos(angle) * 1.2;
            z = entity.getZ() + Math.sin(angle) * 1.2;
            y = entity.getY() + serverLevel.random.nextDouble() * (double)entity.getBbHeight();
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.ENCHANT, x, y, z, 1, 0.0, 0.0, 0.0, 0.1);
        }
        if (this.imprintProgress % 3 == 0) {
            double helixAngle = (double)this.imprintProgress * 0.3 % (Math.PI * 2);
            x = entity.getX() + Math.cos(helixAngle) * 0.4;
            z = entity.getZ() + Math.sin(helixAngle) * 0.4;
            y = (double)this.worldPosition.getY() + 0.5 + (double)(this.imprintProgress % 40) * 0.05;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.PORTAL, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
        if (this.imprintProgress % 10 == 0) {
            float pitch = 1.5f + (float)this.imprintProgress / 60.0f * 0.5f;
            this.level.playSound(null, this.worldPosition, SoundEvents.BEACON_AMBIENT, SoundSource.BLOCKS, 0.3f, pitch);
        }
    }

    private void completeImprinting(LivingEntity entity, NeurocellBlockEntity neurocell) {
        this.imprintEntityDNA(neurocell, entity);
        this.applyImprintingConsequences(entity);
        this.spawnCompletionEffects(entity);
        this.resetImprinting();
    }

    private void applyImprintingConsequences(LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.applyPlayerConsequences(player);
        } else {
            entity.kill();
        }
    }

    private void applyPlayerConsequences(Player player) {
        float damageAmount = player.getHealth() - 2.0f;
        if (damageAmount > 0.0f) {
            player.hurt(player.level().damageSources().magic(), damageAmount);
        }
    }

    private void spawnCompletionEffects(LivingEntity entity) {
        double offsetZ;
        double offsetX;
        int i;
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        for (i = 0; i < 25; ++i) {
            offsetX = (this.level.random.nextDouble() - 0.5) * 0.8;
            offsetZ = (this.level.random.nextDouble() - 0.5) * 0.8;
            double offsetY = this.level.random.nextDouble() * 0.5;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.ENCHANTED_HIT, entity.getX() + offsetX, entity.getY() + offsetY, entity.getZ() + offsetZ, 1, 0.0, 0.5, 0.0, 0.05);
        }
        for (i = 0; i < 15; ++i) {
            offsetX = (this.level.random.nextDouble() - 0.5) * 0.5;
            offsetZ = (this.level.random.nextDouble() - 0.5) * 0.5;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.GLOW, (double)this.worldPosition.getX() + 0.5 + offsetX, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5 + offsetZ, 1, 0.0, 0.3, 0.0, 0.02);
        }
        this.level.playSound(null, entity.blockPosition(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.BLOCKS, 0.8f, 1.5f);
        this.level.playSound(null, entity.blockPosition(), SoundEvents.AMETHYST_BLOCK_CHIME, SoundSource.BLOCKS, 0.6f, 1.8f);
    }

    @Nullable
    private NeurocellBlockEntity findConnectedNeurocellWithEmptyBioscanner() {
        return NeurocellConnector.findConnectedNeurocellFromBack(this.level, this.worldPosition, this::hasEmptyBioscanner);
    }

    private boolean hasEmptyBioscanner(NeurocellBlockEntity neurocell) {
        ItemStack stack = neurocell.getInventory().getItem(0);
        if (stack.isEmpty()) {
            return false;
        }
        if (!(stack.getItem() instanceof BioscannerItem)) {
            return false;
        }
        CustomData customData = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        CompoundTag tag = customData.copyTag();
        return !tag.contains("EntityType");
    }

    private void imprintEntityDNA(NeurocellBlockEntity neurocell, LivingEntity entity) {
        ItemStack bioscanner = neurocell.getInventory().getItem(0);
        if (bioscanner.isEmpty()) {
            return;
        }
        String entityTypeString = this.getEntityTypeString(entity);
        String entityName = this.getEntityName(entity);
        bioscanner.update(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY, customData -> {
            CompoundTag tag = customData.copyTag();
            tag.putString("EntityType", entityTypeString);
            tag.putString("EntityName", entityName);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                tag.putUUID("PlayerUUID", player.getUUID());
            }
            return CustomData.of((CompoundTag)tag);
        });
        neurocell.getInventory().setItem(0, bioscanner);
    }

    private String getEntityTypeString(LivingEntity entity) {
        if (entity instanceof Player) {
            return "hologenica:player_clone";
        }
        return EntityType.getKey((EntityType)entity.getType()).toString();
    }

    private String getEntityName(LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player.getDisplayName().getString();
        }
        return entity.hasCustomName() ? entity.getCustomName().getString() : entity.getDisplayName().getString();
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putInt("ImprintProgress", this.imprintProgress);
        tag.putBoolean("IsImprinting", this.isImprinting);
        tag.putString("PlayerName", this.playerName);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.imprintProgress = tag.getInt("ImprintProgress");
        this.isImprinting = tag.getBoolean("IsImprinting");
        this.playerName = tag.getString("PlayerName");
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        tag.putInt("ImprintProgress", this.imprintProgress);
        tag.putBoolean("IsImprinting", this.isImprinting);
        tag.putString("PlayerName", this.playerName);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public boolean isImprinting() {
        return this.isImprinting;
    }

    public float getImprintProgress() {
        if (!this.isImprinting) {
            return 0.0f;
        }
        return (float)this.imprintProgress / 100.0f;
    }
}

