/*
 * Decompiled with CFR 0.152.
 */
package com.modvane.hologenica.block.entity;

import com.modvane.hologenica.block.NeurocellBlock;
import com.modvane.hologenica.menu.NeurocellMenu;
import com.modvane.hologenica.registry.HologenicaBlockEntities;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class NeurocellBlockEntity
extends BlockEntity
implements MenuProvider {
    private final SimpleContainer inventory = new SimpleContainer(1){

        public void setChanged() {
            super.setChanged();
            NeurocellBlockEntity.this.setChanged();
            NeurocellBlockEntity.this.onInventoryChanged();
        }
    };
    private String entityType = "";
    private String entityName = "";
    private UUID playerUUID = null;
    private int cloningTime = 0;
    private boolean hasRagdoll = false;
    private static final int CLONING_DURATION = 300;

    public NeurocellBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)HologenicaBlockEntities.NEUROCELL.get(), pos, state);
    }

    public SimpleContainer getInventory() {
        return this.inventory;
    }

    private void onInventoryChanged() {
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        ItemStack bioscannerStack = this.inventory.getItem(0);
        if (bioscannerStack.isEmpty() || !bioscannerStack.has(DataComponents.CUSTOM_DATA)) {
            this.clearRagdollState();
            return;
        }
        CustomData customData = (CustomData)bioscannerStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        CompoundTag tag = customData.copyTag();
        if (!tag.contains("EntityType")) {
            this.clearRagdollState();
            return;
        }
        String newEntityType = tag.getString("EntityType");
        if (!newEntityType.equals(this.entityType)) {
            this.entityType = newEntityType;
            this.entityName = tag.contains("EntityName") ? tag.getString("EntityName") : "";
            this.playerUUID = tag.hasUUID("PlayerUUID") ? tag.getUUID("PlayerUUID") : null;
            this.cloningTime = 0;
            this.hasRagdoll = true;
            this.setChanged();
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    private void clearRagdollState() {
        if (this.entityType.isEmpty() && !this.hasRagdoll) {
            return;
        }
        this.entityType = "";
        this.entityName = "";
        this.playerUUID = null;
        this.cloningTime = 0;
        this.hasRagdoll = false;
        this.setChanged();
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }

    public void clearRagdoll() {
        this.clearRagdollState();
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putString("EntityType", this.entityType);
        tag.putString("EntityName", this.entityName);
        if (this.playerUUID != null) {
            tag.putUUID("PlayerUUID", this.playerUUID);
        }
        tag.putInt("CloningTime", this.cloningTime);
        tag.putBoolean("HasRagdoll", this.hasRagdoll);
        NonNullList items = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
        items.set(0, (Object)this.inventory.getItem(0));
        ContainerHelper.saveAllItems((CompoundTag)tag, (NonNullList)items, (HolderLookup.Provider)provider);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.entityType = tag.getString("EntityType");
        this.entityName = tag.getString("EntityName");
        this.playerUUID = tag.hasUUID("PlayerUUID") ? tag.getUUID("PlayerUUID") : null;
        this.cloningTime = tag.getInt("CloningTime");
        this.hasRagdoll = tag.getBoolean("HasRagdoll");
        NonNullList items = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)tag, (NonNullList)items, (HolderLookup.Provider)provider);
        this.inventory.setItem(0, (ItemStack)items.get(0));
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.hologenica.neurocell");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        return new NeurocellMenu(containerId, playerInventory, this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        tag.putString("EntityType", this.entityType);
        tag.putString("EntityName", this.entityName);
        if (this.playerUUID != null) {
            tag.putUUID("PlayerUUID", this.playerUUID);
        }
        tag.putInt("CloningTime", this.cloningTime);
        tag.putBoolean("HasRagdoll", this.hasRagdoll);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public String getEntityType() {
        return this.entityType;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public int getCloningTime() {
        return this.cloningTime;
    }

    public int getCloningDuration() {
        return 300;
    }

    public boolean isCloning() {
        return !this.entityType.isEmpty() && this.cloningTime < 300 && !this.hasRagdoll;
    }

    public boolean hasRagdoll() {
        return this.hasRagdoll;
    }

    public float getCloningProgress() {
        if (this.hasRagdoll || this.entityType.isEmpty()) {
            return 1.0f;
        }
        return (float)this.cloningTime / 300.0f;
    }

    public boolean acceptsConnectionFrom(Direction direction) {
        if (this.level == null) {
            return false;
        }
        BlockState state = this.getBlockState();
        if (!(state.getBlock() instanceof NeurocellBlock)) {
            return false;
        }
        Direction facing = (Direction)state.getValue((Property)NeurocellBlock.FACING);
        Direction back = facing.getOpposite();
        return direction == back;
    }

    public boolean isBackConnection(Direction direction) {
        if (this.level == null) {
            return false;
        }
        BlockState state = this.getBlockState();
        if (!(state.getBlock() instanceof NeurocellBlock)) {
            return false;
        }
        Direction facing = (Direction)state.getValue((Property)NeurocellBlock.FACING);
        Direction back = facing.getOpposite();
        return direction == back;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }
}

