/*
 * Decompiled with CFR 0.152.
 */
package com.modvane.hologenica.block.entity;

import com.modvane.hologenica.block.entity.NeurocellBlockEntity;
import com.modvane.hologenica.entity.PlayerCloneEntity;
import com.modvane.hologenica.registry.HologenicaBlockEntities;
import com.modvane.hologenica.util.NeurocellConnector;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ReformerBlockEntity
extends BlockEntity {
    private String entityType = "";
    private String entityName = "";
    private UUID playerUUID = null;
    private int reconstructionProgress = 0;
    private int reconstructionDuration = 0;
    private boolean isReconstructing = false;

    public ReformerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)HologenicaBlockEntities.REFORMER.get(), pos, state);
    }

    public void tick() {
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        if (!this.isReconstructing) {
            this.checkForAdjacentCloningChamber();
        }
        if (this.isReconstructing && !this.entityType.isEmpty() && this.reconstructionDuration > 0) {
            NeurocellBlockEntity connectedPod = this.findConnectedNeurocell();
            if (connectedPod == null || !connectedPod.hasRagdoll() || connectedPod.getEntityType().isEmpty()) {
                this.resetReconstruction();
                return;
            }
            ++this.reconstructionProgress;
            this.setChanged();
            if (this.reconstructionProgress % 5 == 0) {
                this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
            }
            if (this.reconstructionProgress >= this.reconstructionDuration) {
                this.spawnClonedEntity();
            }
        }
    }

    private void checkForAdjacentCloningChamber() {
        if (this.level == null) {
            return;
        }
        NeurocellBlockEntity connectedPod = this.findConnectedNeurocell();
        if (connectedPod != null && connectedPod.hasRagdoll() && !connectedPod.getEntityType().isEmpty()) {
            this.startReconstruction(connectedPod);
        }
    }

    @Nullable
    private NeurocellBlockEntity findConnectedNeurocell() {
        return NeurocellConnector.findConnectedNeurocell(this.level, this.worldPosition, this::isValidNeurocellForReformer);
    }

    private boolean isValidNeurocellForReformer(NeurocellBlockEntity neurocell) {
        return neurocell.hasRagdoll() && !neurocell.getEntityType().isEmpty();
    }

    private void startReconstruction(NeurocellBlockEntity neurocell) {
        this.entityType = neurocell.getEntityType();
        this.entityName = neurocell.getEntityName();
        this.reconstructionProgress = 0;
        ItemStack bioscanner = neurocell.getInventory().getItem(0);
        if (!bioscanner.isEmpty()) {
            CustomData customData = (CustomData)bioscanner.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
            CompoundTag tag = customData.copyTag();
            this.playerUUID = tag.hasUUID("PlayerUUID") ? tag.getUUID("PlayerUUID") : null;
        }
        this.reconstructionDuration = this.calculateReconstructionDuration(this.entityType);
        this.isReconstructing = true;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    private void resetReconstruction() {
        this.entityType = "";
        this.entityName = "";
        this.playerUUID = null;
        this.reconstructionProgress = 0;
        this.reconstructionDuration = 0;
        this.isReconstructing = false;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    private int calculateReconstructionDuration(String entityTypeString) {
        if (this.level == null) {
            return 1200;
        }
        try {
            Entity entity;
            ResourceLocation entityId = ResourceLocation.parse((String)entityTypeString);
            EntityType type = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(entityId);
            if (type != null && (entity = type.create(this.level)) instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                float maxHealth = livingEntity.getMaxHealth();
                return (int)(maxHealth * 120.0f);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 1200;
    }

    private void spawnClonedEntity() {
        Level level;
        if (this.level == null || !((level = this.level) instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (this.entityType.isEmpty()) {
            return;
        }
        try {
            BlockPos spawnPos;
            Entity entity;
            ResourceLocation entityId = ResourceLocation.parse((String)this.entityType);
            EntityType type = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(entityId);
            if (type != null && (entity = type.create(serverLevel, null, spawnPos = this.worldPosition, MobSpawnType.SPAWNER, false, false)) != null) {
                if (entity instanceof PlayerCloneEntity) {
                    PlayerCloneEntity clone = (PlayerCloneEntity)entity;
                    if (!this.entityName.isEmpty()) {
                        clone.setOwnerName(this.entityName);
                    }
                    if (this.playerUUID != null) {
                        clone.setPlayerUUID(this.playerUUID);
                    }
                }
                entity.setPos((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5);
                serverLevel.addFreshEntity(entity);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.entityType = "";
        this.entityName = "";
        this.playerUUID = null;
        this.reconstructionProgress = 0;
        this.reconstructionDuration = 0;
        this.isReconstructing = false;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putString("EntityType", this.entityType);
        tag.putString("EntityName", this.entityName);
        if (this.playerUUID != null) {
            tag.putUUID("PlayerUUID", this.playerUUID);
        }
        tag.putInt("ReconstructionProgress", this.reconstructionProgress);
        tag.putInt("ReconstructionDuration", this.reconstructionDuration);
        tag.putBoolean("IsReconstructing", this.isReconstructing);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.entityType = tag.getString("EntityType");
        this.entityName = tag.getString("EntityName");
        this.playerUUID = tag.hasUUID("PlayerUUID") ? tag.getUUID("PlayerUUID") : null;
        this.reconstructionProgress = tag.getInt("ReconstructionProgress");
        this.reconstructionDuration = tag.getInt("ReconstructionDuration");
        this.isReconstructing = tag.getBoolean("IsReconstructing");
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        tag.putString("EntityType", this.entityType);
        tag.putString("EntityName", this.entityName);
        if (this.playerUUID != null) {
            tag.putUUID("PlayerUUID", this.playerUUID);
        }
        tag.putInt("ReconstructionProgress", this.reconstructionProgress);
        tag.putInt("ReconstructionDuration", this.reconstructionDuration);
        tag.putBoolean("IsReconstructing", this.isReconstructing);
        return tag;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public String getEntityType() {
        return this.entityType;
    }

    public int getReconstructionProgress() {
        return this.reconstructionProgress;
    }

    public boolean isReconstructing() {
        return this.isReconstructing;
    }

    public float getProgressPercentage() {
        if (this.reconstructionDuration <= 0) {
            return 0.0f;
        }
        return (float)this.reconstructionProgress / (float)this.reconstructionDuration;
    }

    public int getReconstructionDuration() {
        return this.reconstructionDuration;
    }
}

