/*
 * Decompiled with CFR 0.152.
 */
package com.modvane.hologenica.block.entity;

import com.modvane.hologenica.menu.TelepadMenu;
import com.modvane.hologenica.registry.HologenicaBlockEntities;
import com.modvane.hologenica.world.TelepadRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class TelepadBlockEntity
extends BlockEntity
implements MenuProvider {
    private String telepadName = "";
    private final Map<UUID, Integer> chargingPlayers = new HashMap<UUID, Integer>();
    private final Map<UUID, Long> recentArrivals = new HashMap<UUID, Long>();

    public TelepadBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)HologenicaBlockEntities.TELEPAD.get(), pos, state);
    }

    public String getTelepadName() {
        return this.telepadName;
    }

    public void setTelepadName(String name) {
        this.telepadName = name;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.updateRegistry();
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
    }

    private void updateRegistry() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            TelepadRegistry registry = TelepadRegistry.get(serverLevel.getServer());
            if (!this.telepadName.isEmpty()) {
                registry.registerTelepad(this.telepadName, (ResourceKey<Level>)serverLevel.dimension(), this.getBlockPos());
            } else {
                registry.unregisterTelepad((ResourceKey<Level>)serverLevel.dimension(), this.getBlockPos());
            }
        }
    }

    public void removeFromRegistry() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            TelepadRegistry registry = TelepadRegistry.get(serverLevel.getServer());
            registry.unregisterTelepad((ResourceKey<Level>)serverLevel.dimension(), this.getBlockPos());
        }
    }

    public void tick() {
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        long currentTime = this.level.getGameTime();
        this.recentArrivals.entrySet().removeIf(entry -> currentTime - (Long)entry.getValue() > 60L);
        ArrayList<UUID> toRemove = new ArrayList<UUID>();
        for (Map.Entry<UUID, Integer> entry2 : this.chargingPlayers.entrySet()) {
            UUID playerId = entry2.getKey();
            int chargeTime = entry2.getValue();
            Player player = this.level.getPlayerByUUID(playerId);
            if (player == null || !this.isPlayerOnTelepad(player)) {
                toRemove.add(playerId);
                continue;
            }
            this.chargingPlayers.put(playerId, ++chargeTime);
            if (chargeTime % 2 == 0) {
                this.spawnChargingParticles(player);
            }
            if (chargeTime == 1) {
                this.level.playSound(null, this.worldPosition, SoundEvents.BEACON_ACTIVATE, SoundSource.BLOCKS, 0.5f, 1.5f);
            } else if (chargeTime % 10 == 0 && chargeTime < 40) {
                this.level.playSound(null, this.worldPosition, SoundEvents.BEACON_AMBIENT, SoundSource.BLOCKS, 0.3f, 1.8f);
            }
            if (chargeTime < 40) continue;
            this.executeTeleport((ServerPlayer)player);
            toRemove.add(playerId);
        }
        toRemove.forEach(this.chargingPlayers::remove);
    }

    private boolean isPlayerOnTelepad(Player player) {
        BlockPos playerPos = player.blockPosition();
        return playerPos.equals((Object)this.worldPosition) || playerPos.getX() == this.worldPosition.getX() && playerPos.getZ() == this.worldPosition.getZ() && Math.abs(playerPos.getY() - this.worldPosition.getY()) <= 1;
    }

    public void startCharging(Player player) {
        if (this.level == null || this.level.isClientSide || !(player instanceof ServerPlayer)) {
            return;
        }
        UUID playerId = player.getUUID();
        if (this.recentArrivals.containsKey(playerId)) {
            long arrivedAt = this.recentArrivals.get(playerId);
            long currentTime = this.level.getGameTime();
            if (currentTime - arrivedAt < 60L) {
                return;
            }
        }
        if (this.telepadName.isEmpty()) {
            player.displayClientMessage((Component)Component.literal((String)"Telepad not configured!"), true);
            return;
        }
        if (this.chargingPlayers.containsKey(playerId)) {
            return;
        }
        this.chargingPlayers.put(playerId, 0);
    }

    private void executeTeleport(ServerPlayer player) {
        if (this.level == null) {
            return;
        }
        List<TelepadDestination> destinations = this.findMatchingTelepads(this.level.getServer());
        if (destinations.isEmpty()) {
            player.displayClientMessage((Component)Component.literal((String)("No destination found: " + this.telepadName)), true);
            return;
        }
        TelepadDestination dest = destinations.get(this.level.random.nextInt(destinations.size()));
        this.spawnTeleportParticles(player.position());
        this.level.playSound(null, this.worldPosition, SoundEvents.BEACON_POWER_SELECT, SoundSource.BLOCKS, 0.6f, 1.4f);
        dest.level.getChunk(dest.pos);
        player.teleportTo(dest.level, (double)dest.pos.getX() + 0.5, (double)dest.pos.getY() + 0.5, (double)dest.pos.getZ() + 0.5, player.getYRot(), player.getXRot());
        BlockEntity blockEntity = dest.level.getBlockEntity(dest.pos);
        if (blockEntity instanceof TelepadBlockEntity) {
            TelepadBlockEntity destTelepad = (TelepadBlockEntity)blockEntity;
            destTelepad.markPlayerArrival(player.getUUID());
        }
        dest.level.playSound(null, dest.pos, SoundEvents.BEACON_POWER_SELECT, SoundSource.BLOCKS, 0.6f, 1.6f);
        this.spawnArrivalParticlesAt(dest.level, dest.pos);
        player.displayClientMessage((Component)Component.literal((String)("Teleported to: " + this.telepadName)), true);
    }

    public void markPlayerArrival(UUID playerId) {
        if (this.level != null) {
            this.recentArrivals.put(playerId, this.level.getGameTime());
        }
    }

    private void spawnChargingParticles(Player player) {
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        double x = player.getX();
        double y = player.getY();
        double z = player.getZ();
        for (int i = 0; i < 3; ++i) {
            double angle = Math.random() * Math.PI * 2.0;
            double radius = 0.5 + Math.random() * 0.5;
            double offsetX = Math.cos(angle) * radius;
            double offsetZ = Math.sin(angle) * radius;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.PORTAL, x + offsetX, y + Math.random(), z + offsetZ, 1, 0.0, 0.0, 0.0, 0.05);
        }
    }

    private void spawnTeleportParticles(Vec3 pos) {
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        this.spawnTeleportParticlesAt(serverLevel, pos.x, pos.y, pos.z);
    }

    private void spawnArrivalParticlesAt(ServerLevel serverLevel, BlockPos pos) {
        this.spawnTeleportParticlesAt(serverLevel, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
    }

    private void spawnTeleportParticlesAt(ServerLevel serverLevel, double x, double y, double z) {
        serverLevel.sendParticles((ParticleOptions)ParticleTypes.PORTAL, x, y + 0.5, z, 50, 0.3, 0.5, 0.3, 0.5);
        serverLevel.sendParticles((ParticleOptions)ParticleTypes.END_ROD, x, y + 0.5, z, 20, 0.2, 0.3, 0.2, 0.1);
    }

    private List<TelepadDestination> findMatchingTelepads(@Nullable MinecraftServer server) {
        ArrayList<TelepadDestination> destinations = new ArrayList<TelepadDestination>();
        if (server == null || this.telepadName.isEmpty()) {
            return destinations;
        }
        TelepadRegistry registry = TelepadRegistry.get(server);
        List<TelepadRegistry.TelepadLocation> locations = registry.findTelepads(this.telepadName);
        for (TelepadRegistry.TelepadLocation loc : locations) {
            ServerLevel targetLevel;
            Level level;
            if (loc.pos().equals((Object)this.getBlockPos()) && (level = this.level) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (loc.dimension().equals((Object)serverLevel.dimension())) continue;
            }
            if ((targetLevel = server.getLevel(loc.dimension())) == null) continue;
            destinations.add(new TelepadDestination(targetLevel, loc.pos()));
        }
        return destinations;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putString("TelepadName", this.telepadName);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("TelepadName")) {
            this.telepadName = tag.getString("TelepadName");
        }
    }

    public void onLoad() {
        super.onLoad();
        if (this.level != null && !this.level.isClientSide) {
            this.updateRegistry();
        }
    }

    public void setRemoved() {
        super.setRemoved();
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        tag.putString("TelepadName", this.telepadName);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.hologenica.telepad");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        return new TelepadMenu(containerId, playerInventory, this);
    }

    public void writeExtraData(RegistryFriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.getBlockPos());
    }

    private static class TelepadDestination {
        final ServerLevel level;
        final BlockPos pos;

        TelepadDestination(ServerLevel level, BlockPos pos) {
            this.level = level;
            this.pos = pos;
        }
    }
}

