/*
 * Decompiled with CFR 0.152.
 */
package com.modvane.hologenica.client.renderer;

import com.modvane.hologenica.block.entity.HologramBlockEntity;
import com.modvane.hologenica.client.renderer.HologramRendererClassic;
import com.modvane.hologenica.client.renderer.HologramRendererRealistic;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.level.Level;
import org.joml.Quaternionf;

public class HologramRenderer
implements BlockEntityRenderer<HologramBlockEntity> {
    public HologramRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(HologramBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        if (!blockEntity.hasValidRegion() || blockEntity.getLevel() == null) {
            return;
        }
        Level level = blockEntity.getLevel();
        int minX = blockEntity.getScanMinX();
        int maxX = blockEntity.getScanMaxX();
        int minZ = blockEntity.getScanMinZ();
        int maxZ = blockEntity.getScanMaxZ();
        HologramBlockEntity.RenderStyle style = blockEntity.getRenderStyle();
        int[][][] terrain = blockEntity.getCachedTerrain();
        if (terrain == null || blockEntity.needsRescan()) {
            switch (style) {
                default: {
                    throw new MatchException(null, null);
                }
                case CLASSIC: {
                    int[][][] nArray = HologramRendererClassic.scanTerrain(level, minX, maxX, minZ, maxZ);
                    break;
                }
                case REALISTIC: {
                    int[][][] nArray = terrain = HologramRendererRealistic.scanTerrain(level, minX, maxX, minZ, maxZ);
                }
            }
            if (terrain == null) {
                return;
            }
            blockEntity.setCachedTerrain(terrain);
        }
        int width = maxX - minX + 1;
        int depth = maxZ - minZ + 1;
        poseStack.pushPose();
        poseStack.translate(0.5, 2.0, 0.5);
        if (blockEntity.isRotationEnabled()) {
            long time = level.getGameTime();
            float rotation = ((float)time + partialTick) * 0.5f;
            poseStack.mulPose(new Quaternionf().rotationY((float)Math.toRadians(rotation)));
        }
        int blockSize = blockEntity.getBlockSize();
        float scale = (float)blockSize / (float)Math.max(width, depth);
        poseStack.scale(scale, scale, scale);
        poseStack.translate((float)(-width) / 2.0f, 0.0f, (float)(-depth) / 2.0f);
        boolean transparent = blockEntity.isTransparentMode();
        switch (style) {
            case CLASSIC: {
                HologramRendererClassic.render(poseStack, buffer, terrain, width, depth, transparent);
                break;
            }
            case REALISTIC: {
                HologramRendererRealistic.render(poseStack, buffer, terrain, width, depth, transparent);
            }
        }
        poseStack.popPose();
    }
}

