/*
 * Decompiled with CFR 0.152.
 */
package com.modvane.hologenica.client.renderer;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Matrix4f;

public class HologramRendererClassic {
    private static final int FULL_BRIGHT = 0xF000F0;
    private static final RenderType VOLUMETRIC_QUADS = RenderType.create((String)"hologenica_volumetric", (VertexFormat)DefaultVertexFormat.POSITION_COLOR_LIGHTMAP, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderStateShard.POSITION_COLOR_LIGHTMAP_SHADER).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setLightmapState(RenderStateShard.LIGHTMAP).setWriteMaskState(RenderStateShard.COLOR_DEPTH_WRITE).setDepthTestState(RenderStateShard.LEQUAL_DEPTH_TEST).setCullState(RenderStateShard.NO_CULL).createCompositeState(false));

    public static void render(PoseStack poseStack, MultiBufferSource buffer, int[][][] terrain, int width, int depth, boolean transparent) {
        if (terrain == null || terrain.length != width || terrain[0].length == 0 || terrain[0][0].length != depth) {
            return;
        }
        int height = terrain[0].length;
        VertexConsumer consumer = buffer.getBuffer(VOLUMETRIC_QUADS);
        Matrix4f matrix = poseStack.last().pose();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < depth; ++z) {
                    int color = terrain[x][y][z];
                    if (color == 0) continue;
                    HologramRendererClassic.renderVolumetricBlock(consumer, matrix, terrain, x, y, z, width, height, depth, color, transparent);
                }
            }
        }
    }

    private static void renderVolumetricBlock(VertexConsumer c, Matrix4f m, int[][][] terrain, int x, int y, int z, int width, int height, int depth, int color, boolean transparent) {
        int baseR = color >> 16 & 0xFF;
        int baseG = color >> 8 & 0xFF;
        int baseB = color & 0xFF;
        float heightRatio = (float)y / (float)height;
        int r = (int)((float)baseR * (0.4f + heightRatio * 0.6f) + 50.0f * heightRatio);
        int g = (int)((float)baseG * (0.4f + heightRatio * 0.6f) + 120.0f * heightRatio);
        int b = (int)((float)baseB * (0.5f + heightRatio * 0.5f) + 180.0f - 80.0f * heightRatio);
        r = Math.min(255, Math.max(0, r));
        g = Math.min(255, Math.max(0, g));
        b = Math.min(255, Math.max(0, b));
        int a = transparent ? 200 : 255;
        float x1 = x;
        float y1 = y;
        float z1 = z;
        float x2 = x + 1;
        float y2 = y + 1;
        float z2 = z + 1;
        float inset = 0.02f;
        if (y + 1 >= height || terrain[x][y + 1][z] == 0) {
            HologramRendererClassic.addQuad(c, m, x1 + inset, y2, z2 - inset, x2 - inset, y2, z2 - inset, x2 - inset, y2, z1 + inset, x1 + inset, y2, z1 + inset, r, g, b, a);
        }
        if (y - 1 < 0 || terrain[x][y - 1][z] == 0) {
            HologramRendererClassic.addQuad(c, m, x1 + inset, y1, z1 + inset, x2 - inset, y1, z1 + inset, x2 - inset, y1, z2 - inset, x1 + inset, y1, z2 - inset, r, g, b, a);
        }
        if (z - 1 < 0 || terrain[x][y][z - 1] == 0) {
            HologramRendererClassic.addQuad(c, m, x2 - inset, y1 + inset, z1, x1 + inset, y1 + inset, z1, x1 + inset, y2 - inset, z1, x2 - inset, y2 - inset, z1, r, g, b, a);
        }
        if (z + 1 >= depth || terrain[x][y][z + 1] == 0) {
            HologramRendererClassic.addQuad(c, m, x1 + inset, y1 + inset, z2, x2 - inset, y1 + inset, z2, x2 - inset, y2 - inset, z2, x1 + inset, y2 - inset, z2, r, g, b, a);
        }
        if (x - 1 < 0 || terrain[x - 1][y][z] == 0) {
            HologramRendererClassic.addQuad(c, m, x1, y1 + inset, z1 + inset, x1, y1 + inset, z2 - inset, x1, y2 - inset, z2 - inset, x1, y2 - inset, z1 + inset, r, g, b, a);
        }
        if (x + 1 >= width || terrain[x + 1][y][z] == 0) {
            HologramRendererClassic.addQuad(c, m, x2, y1 + inset, z2 - inset, x2, y1 + inset, z1 + inset, x2, y2 - inset, z1 + inset, x2, y2 - inset, z2 - inset, r, g, b, a);
        }
    }

    private static void addQuad(VertexConsumer c, Matrix4f m, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, int r, int g, int b, int a) {
        c.addVertex(m, x1, y1, z1).setColor(r, g, b, a).setLight(0xF000F0);
        c.addVertex(m, x2, y2, z2).setColor(r, g, b, a).setLight(0xF000F0);
        c.addVertex(m, x3, y3, z3).setColor(r, g, b, a).setLight(0xF000F0);
        c.addVertex(m, x4, y4, z4).setColor(r, g, b, a).setLight(0xF000F0);
    }

    public static int[][][] scanTerrain(Level level, int minX, int maxX, int minZ, int maxZ) {
        int width = maxX - minX + 1;
        int depth = maxZ - minZ + 1;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int minY = level.getMaxBuildHeight();
        int maxY = level.getMinBuildHeight();
        boolean foundBlocks = false;
        for (int x = minX; x <= maxX; ++x) {
            block1: for (int z = minZ; z <= maxZ; ++z) {
                for (int y = level.getMaxBuildHeight() - 1; y >= level.getMinBuildHeight(); --y) {
                    BlockState state = level.getBlockState((BlockPos)pos.set(x, y, z));
                    if (state.isAir()) continue;
                    minY = Math.min(minY, y);
                    maxY = Math.max(maxY, y);
                    foundBlocks = true;
                    continue block1;
                }
            }
        }
        if (!foundBlocks) {
            minY = level.getMinBuildHeight();
            maxY = level.getMinBuildHeight();
        }
        int height = Math.max(1, maxY - minY + 1);
        int[][][] terrain = new int[width][height][depth];
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < depth; ++z) {
                    BlockState state = level.getBlockState((BlockPos)pos.set(minX + x, minY + y, minZ + z));
                    if (state.isAir()) continue;
                    terrain[x][y][z] = state.getMapColor((BlockGetter)level, (BlockPos)pos).col;
                }
            }
        }
        return terrain;
    }
}

