/*
 * Decompiled with CFR 0.152.
 */
package com.modvane.hologenica.client.renderer;

import com.modvane.hologenica.HologenicaMod;
import com.modvane.hologenica.block.entity.NeurocellBlockEntity;
import com.modvane.hologenica.entity.PlayerCloneEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;

public class NeurocellRenderer
implements BlockEntityRenderer<NeurocellBlockEntity> {
    private final EntityRenderDispatcher entityRenderer;
    private final Map<String, Entity> entityCache = new HashMap<String, Entity>();

    public NeurocellRenderer(BlockEntityRendererProvider.Context context) {
        this.entityRenderer = Minecraft.getInstance().getEntityRenderDispatcher();
    }

    public void render(NeurocellBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        String entityTypeString = blockEntity.getEntityType();
        if (entityTypeString == null || entityTypeString.isEmpty()) {
            return;
        }
        boolean isCloning = blockEntity.isCloning();
        boolean hasRagdoll = blockEntity.hasRagdoll();
        if (!isCloning && !hasRagdoll) {
            return;
        }
        float progress = blockEntity.getCloningProgress();
        try {
            ResourceLocation entityId = ResourceLocation.parse((String)entityTypeString);
            EntityType type = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(entityId);
            if (type == null) {
                if (blockEntity.getLevel() != null && blockEntity.getLevel().getGameTime() % 100L == 0L) {
                    HologenicaMod.LOGGER.warn("Failed to find entity type in registry: {}", (Object)entityTypeString);
                }
                return;
            }
            if (type != null && blockEntity.getLevel() != null) {
                Entity entity = this.entityCache.get(entityTypeString);
                if (entity == null && (entity = type.create(blockEntity.getLevel())) != null) {
                    this.entityCache.put(entityTypeString, entity);
                }
                if (entity != null) {
                    if (entity instanceof PlayerCloneEntity) {
                        PlayerCloneEntity clone = (PlayerCloneEntity)entity;
                        UUID playerUUID = blockEntity.getPlayerUUID();
                        if (playerUUID != null) {
                            clone.setPlayerUUID(playerUUID);
                        }
                    }
                    poseStack.pushPose();
                    long worldTime = blockEntity.getLevel().getGameTime();
                    float time = ((float)worldTime + partialTick) / 20.0f;
                    float bobOffset = 0.0f;
                    if (hasRagdoll && !isCloning) {
                        bobOffset = ((float)Math.sin((double)time * 2.0) + 1.0f) / 2.0f * 0.06f;
                    }
                    poseStack.translate(0.5, 0.5625 + (double)bobOffset, 0.5);
                    float rotationAngle = 180.0f;
                    if (hasRagdoll && !isCloning) {
                        rotationAngle += time * 30.0f % 360.0f;
                    }
                    poseStack.mulPose(Axis.YP.rotationDegrees(rotationAngle));
                    float entityWidth = entity.getBbWidth();
                    float entityHeight = entity.getBbHeight();
                    float visualMargin = 1.3f;
                    float visualWidth = entityWidth * visualMargin;
                    float visualHeight = entityHeight;
                    float maxDimension = Math.max(visualWidth, visualHeight);
                    float targetSize = 0.85f;
                    float scale = maxDimension > targetSize ? targetSize / maxDimension : 1.0f;
                    scale = Math.max(0.1f, scale);
                    float growthScale = isCloning ? 0.05f + progress * 0.95f : 1.0f;
                    poseStack.scale(scale * growthScale, scale * growthScale, scale * growthScale);
                    entity.setSilent(true);
                    this.entityRenderer.render(entity, 0.0, 0.0, 0.0, 0.0f, partialTick, poseStack, buffer, 0xF000F0);
                    poseStack.popPose();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

