/*
 * Decompiled with CFR 0.152.
 */
package com.modvane.hologenica.client.renderer;

import com.modvane.hologenica.entity.PlayerCloneEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;

public class PlayerCloneRenderer
extends MobRenderer<PlayerCloneEntity, HumanoidModel<PlayerCloneEntity>> {
    private static final ResourceLocation STEVE_SKIN = ResourceLocation.withDefaultNamespace((String)"textures/entity/player/wide/steve.png");
    private final HumanoidModel<PlayerCloneEntity> steveModel;
    private final HumanoidModel<PlayerCloneEntity> alexModel;

    public PlayerCloneRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new HumanoidModel(context.bakeLayer(ModelLayers.PLAYER)), 0.5f);
        this.steveModel = new HumanoidModel(context.bakeLayer(ModelLayers.PLAYER));
        this.alexModel = new HumanoidModel(context.bakeLayer(ModelLayers.PLAYER_SLIM));
    }

    public ResourceLocation getTextureLocation(PlayerCloneEntity entity) {
        PlayerInfo playerInfo;
        ClientPacketListener connection;
        UUID playerUUID = entity.getPlayerUUID();
        if (playerUUID != null && (connection = Minecraft.getInstance().getConnection()) != null && (playerInfo = connection.getPlayerInfo(playerUUID)) != null) {
            this.model = playerInfo.getSkin().model() == PlayerSkin.Model.SLIM ? this.alexModel : this.steveModel;
            return playerInfo.getSkin().texture();
        }
        this.model = this.steveModel;
        return STEVE_SKIN;
    }

    protected void scale(PlayerCloneEntity entity, PoseStack poseStack, float partialTick) {
        poseStack.scale(0.9375f, 0.9375f, 0.9375f);
    }
}

