/*
 * Decompiled with CFR 0.152.
 */
package com.modvane.hologenica.client.renderer;

import com.modvane.hologenica.block.entity.ReformerBlockEntity;
import com.modvane.hologenica.entity.PlayerCloneEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;

public class ReformerRenderer
implements BlockEntityRenderer<ReformerBlockEntity> {
    private final EntityRenderDispatcher entityRenderer;
    private final Map<String, Entity> entityCache = new HashMap<String, Entity>();

    public ReformerRenderer(BlockEntityRendererProvider.Context context) {
        this.entityRenderer = Minecraft.getInstance().getEntityRenderDispatcher();
    }

    public void render(ReformerBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        if (!blockEntity.isReconstructing()) {
            return;
        }
        String entityTypeString = blockEntity.getEntityType();
        if (entityTypeString == null || entityTypeString.isEmpty()) {
            return;
        }
        try {
            ResourceLocation entityId = ResourceLocation.parse((String)entityTypeString);
            EntityType type = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(entityId);
            if (type != null && blockEntity.getLevel() != null) {
                Entity entity = this.entityCache.get(entityTypeString);
                if (entity == null && (entity = type.create(blockEntity.getLevel())) != null) {
                    this.entityCache.put(entityTypeString, entity);
                }
                if (entity != null) {
                    if (entity instanceof PlayerCloneEntity) {
                        PlayerCloneEntity clone = (PlayerCloneEntity)entity;
                        UUID playerUUID = blockEntity.getPlayerUUID();
                        if (playerUUID != null) {
                            clone.setPlayerUUID(playerUUID);
                        }
                    }
                    poseStack.pushPose();
                    poseStack.translate(0.5, 0.5, 0.5);
                    poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                    float growthPercentage = blockEntity.getProgressPercentage();
                    float growthScale = 0.01f + growthPercentage * 0.99f;
                    poseStack.scale(growthScale, growthScale, growthScale);
                    entity.setSilent(true);
                    this.entityRenderer.render(entity, 0.0, 0.0, 0.0, 0.0f, partialTick, poseStack, buffer, 0xF000F0);
                    poseStack.popPose();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

