/*
 * Decompiled with CFR 0.152.
 */
package com.modvane.hologenica.client.screen;

import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public abstract class BaseModScreen<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T> {
    protected static final int PADDING = 10;
    protected static final int BUTTON_HEIGHT = 20;
    protected static final int BUTTON_SPACING = 4;
    protected static final int LABEL_TO_BUTTON = 6;
    protected static final int SECTION_GAP = 16;
    protected static final int FONT_HEIGHT = 9;
    protected static final int DEFAULT_WIDTH = 176;

    public BaseModScreen(T menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
        this.imageWidth = this.getGuiWidth();
        this.imageHeight = this.calculateGuiHeight();
    }

    protected int getGuiWidth() {
        return 176;
    }

    protected abstract int calculateGuiHeight();

    protected int calculateSectionHeight(int buttonRows, boolean hasGapAfter) {
        int height = 15 + 20 * buttonRows;
        if (buttonRows > 1) {
            height += 4 * (buttonRows - 1);
        }
        if (hasGapAfter) {
            height += 16;
        }
        return height;
    }

    protected int getContentWidth() {
        return this.imageWidth - 20;
    }

    protected int getButtonWidth(int buttonsInRow) {
        return (this.getContentWidth() - 4 * (buttonsInRow - 1)) / buttonsInRow;
    }
}

