/*
 * Decompiled with CFR 0.152.
 */
package com.modvane.hologenica.client.screen;

import com.modvane.hologenica.client.gui.ToggleButton;
import com.modvane.hologenica.client.screen.BaseModScreen;
import com.modvane.hologenica.menu.HologramMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class HologramScreen
extends BaseModScreen<HologramMenu> {
    private Button styleButton;

    public HologramScreen(HologramMenu menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
    }

    @Override
    protected int calculateGuiHeight() {
        return 20 + this.calculateSectionHeight(2, true) + this.calculateSectionHeight(1, true) + this.calculateSectionHeight(1, false);
    }

    protected void init() {
        super.init();
        int y = this.topPos + 10;
        int twoButtonWidth = this.getButtonWidth(2);
        this.addRenderableWidget((GuiEventListener)new ToggleButton(this.leftPos + 10, y += 15, twoButtonWidth, 20, (Component)Component.translatable((String)"gui.hologenica.label_transparency"), button -> this.minecraft.gameMode.handleInventoryButtonClick(((HologramMenu)this.menu).containerId, 0), () -> ((HologramMenu)this.menu).isTransparentMode()));
        this.addRenderableWidget((GuiEventListener)new ToggleButton(this.leftPos + 10 + twoButtonWidth + 4, y, twoButtonWidth, 20, (Component)Component.translatable((String)"gui.hologenica.label_rotation"), button -> this.minecraft.gameMode.handleInventoryButtonClick(((HologramMenu)this.menu).containerId, 1), () -> ((HologramMenu)this.menu).isRotationEnabled()));
        this.styleButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)("Style: " + ((HologramMenu)this.menu).getRenderStyleName())), button -> this.minecraft.gameMode.handleInventoryButtonClick(((HologramMenu)this.menu).containerId, 2)).bounds(this.leftPos + 10, y += 24, this.getContentWidth(), 20).build());
        y += 36;
        int threeButtonWidth = this.getButtonWidth(3);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.hologenica.scan_32"), button -> this.minecraft.gameMode.handleInventoryButtonClick(((HologramMenu)this.menu).containerId, 3)).bounds(this.leftPos + 10, y += 15, threeButtonWidth, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.hologenica.scan_64"), button -> this.minecraft.gameMode.handleInventoryButtonClick(((HologramMenu)this.menu).containerId, 4)).bounds(this.leftPos + 10 + threeButtonWidth + 4, y, threeButtonWidth, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.hologenica.scan_128"), button -> this.minecraft.gameMode.handleInventoryButtonClick(((HologramMenu)this.menu).containerId, 5)).bounds(this.leftPos + 10 + 2 * threeButtonWidth + 8, y, threeButtonWidth, 20).build());
        y += 36;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.hologenica.size_1"), button -> this.minecraft.gameMode.handleInventoryButtonClick(((HologramMenu)this.menu).containerId, 6)).bounds(this.leftPos + 10, y += 15, threeButtonWidth, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.hologenica.size_3"), button -> this.minecraft.gameMode.handleInventoryButtonClick(((HologramMenu)this.menu).containerId, 7)).bounds(this.leftPos + 10 + threeButtonWidth + 4, y, threeButtonWidth, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.hologenica.size_9"), button -> this.minecraft.gameMode.handleInventoryButtonClick(((HologramMenu)this.menu).containerId, 8)).bounds(this.leftPos + 10 + 2 * threeButtonWidth + 8, y, threeButtonWidth, 20).build());
    }

    protected void renderBg(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        int x = this.leftPos;
        int y = this.topPos;
        graphics.fill(x, y, x + this.imageWidth, y + this.imageHeight, -1072689136);
        if (this.styleButton != null) {
            this.styleButton.setMessage((Component)Component.literal((String)("Style: " + ((HologramMenu)this.menu).getRenderStyleName())));
        }
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        int y = 10;
        graphics.drawString(this.font, (Component)Component.translatable((String)"gui.hologenica.display_options"), 10, y, 0xFFFFFF, false);
        graphics.drawString(this.font, (Component)Component.translatable((String)"gui.hologenica.scan_area"), 10, y += this.calculateSectionHeight(2, true), 0xFFFFFF, false);
        graphics.drawString(this.font, (Component)Component.translatable((String)"gui.hologenica.display_size"), 10, y += this.calculateSectionHeight(1, true), 0xFFFFFF, false);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

