/*
 * Decompiled with CFR 0.152.
 */
package com.modvane.hologenica.client.screen;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ManualScreen
extends Screen {
    private int currentPage = 0;
    private static final int TOTAL_PAGES = 8;
    private Button prevButton;
    private Button nextButton;
    private int leftPos;
    private int topPos;
    private int imageWidth = 280;
    private int imageHeight = 180;

    public ManualScreen() {
        super((Component)Component.literal((String)"Hologenica Manual"));
    }

    protected void init() {
        super.init();
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        int buttonY = this.topPos + this.imageHeight - 30;
        this.prevButton = Button.builder((Component)Component.literal((String)"<"), button -> {
            if (this.currentPage > 0) {
                --this.currentPage;
            }
        }).bounds(this.leftPos + 20, buttonY, 40, 20).build();
        this.nextButton = Button.builder((Component)Component.literal((String)">"), button -> {
            if (this.currentPage < 7) {
                ++this.currentPage;
            }
        }).bounds(this.leftPos + this.imageWidth - 60, buttonY, 40, 20).build();
        Button closeButton = Button.builder((Component)Component.literal((String)"Close"), button -> this.onClose()).bounds(this.leftPos + this.imageWidth / 2 - 30, buttonY, 60, 20).build();
        this.addRenderableWidget((GuiEventListener)this.prevButton);
        this.addRenderableWidget((GuiEventListener)this.nextButton);
        this.addRenderableWidget((GuiEventListener)closeButton);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        graphics.fill(this.leftPos, this.topPos, this.leftPos + this.imageWidth, this.topPos + this.imageHeight, -1072689136);
        graphics.drawCenteredString(this.font, "Hologenica Manual", this.leftPos + this.imageWidth / 2, this.topPos + 10, 16766720);
        graphics.drawCenteredString(this.font, "Page " + (this.currentPage + 1) + " / 8", this.leftPos + this.imageWidth / 2, this.topPos + 22, 0xAAAAAA);
        this.renderPage(graphics);
        super.render(graphics, mouseX, mouseY, partialTick);
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
    }

    private void renderPage(GuiGraphics graphics) {
        int centerX = this.leftPos + this.imageWidth / 2;
        int startY = this.topPos + 40;
        switch (this.currentPage) {
            case 0: {
                this.renderManualRecipe(graphics, centerX, startY);
                break;
            }
            case 1: {
                this.renderBioscannerRecipe(graphics, centerX, startY);
                break;
            }
            case 2: {
                this.renderImprinterRecipe(graphics, centerX, startY);
                break;
            }
            case 3: {
                this.renderNeurocellRecipe(graphics, centerX, startY);
                break;
            }
            case 4: {
                this.renderReformerRecipe(graphics, centerX, startY);
                break;
            }
            case 5: {
                this.renderNeurolinkRecipe(graphics, centerX, startY);
                break;
            }
            case 6: {
                this.renderHologramRecipe(graphics, centerX, startY);
                break;
            }
            case 7: {
                this.renderTelepadRecipe(graphics, centerX, startY);
            }
        }
    }

    private void renderRecipeTitle(GuiGraphics graphics, String title, int centerX, int y) {
        graphics.drawCenteredString(this.font, title, centerX, y, 16766720);
    }

    private void renderCraftingGrid(GuiGraphics graphics, ItemStack[][] recipe, int centerX, int startY) {
        int gridStartX = centerX - 80;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                int x = gridStartX + col * 18;
                int y = startY + row * 18;
                graphics.fill(x, y, x + 16, y + 16, -1437248171);
                if (recipe[row][col] == null || recipe[row][col].isEmpty()) continue;
                graphics.renderItem(recipe[row][col], x, y);
            }
        }
        graphics.drawString(this.font, "=>", centerX - 10, startY + 22, 0xFFFFFF);
        graphics.fill(centerX + 20, startY + 18, centerX + 36, startY + 34, -1437248171);
    }

    private void renderBioscannerRecipe(GuiGraphics graphics, int centerX, int y) {
        this.renderRecipeTitle(graphics, "Bioscanner Recipe", centerX, y);
        ItemStack[][] recipe = new ItemStack[3][3];
        recipe[0][0] = new ItemStack((ItemLike)Items.GLASS_PANE);
        recipe[0][1] = new ItemStack((ItemLike)Items.REDSTONE);
        recipe[0][2] = new ItemStack((ItemLike)Items.GLASS_PANE);
        recipe[1][0] = new ItemStack((ItemLike)Items.IRON_INGOT);
        recipe[1][1] = new ItemStack((ItemLike)Items.REDSTONE_BLOCK);
        recipe[1][2] = new ItemStack((ItemLike)Items.IRON_INGOT);
        recipe[2][0] = new ItemStack((ItemLike)Items.IRON_INGOT);
        recipe[2][1] = new ItemStack((ItemLike)Items.REDSTONE);
        recipe[2][2] = new ItemStack((ItemLike)Items.IRON_INGOT);
        this.renderCraftingGrid(graphics, recipe, centerX, y + 15);
        ItemStack result = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"hologenica", (String)"bioscanner")));
        graphics.renderItem(result, centerX + 20, y + 33);
    }

    private void renderNeurolinkRecipe(GuiGraphics graphics, int centerX, int y) {
        this.renderRecipeTitle(graphics, "Neurolink Recipe (yields 8)", centerX, y);
        ItemStack[][] recipe = new ItemStack[3][3];
        recipe[0][1] = new ItemStack((ItemLike)Items.IRON_NUGGET);
        recipe[1][0] = new ItemStack((ItemLike)Items.COPPER_INGOT);
        recipe[1][1] = new ItemStack((ItemLike)Items.REDSTONE);
        recipe[1][2] = new ItemStack((ItemLike)Items.COPPER_INGOT);
        recipe[2][1] = new ItemStack((ItemLike)Items.IRON_NUGGET);
        this.renderCraftingGrid(graphics, recipe, centerX, y + 15);
        ItemStack result = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"hologenica", (String)"neurolink")), 8);
        graphics.renderItem(result, centerX + 20, y + 33);
        graphics.renderItemDecorations(this.font, result, centerX + 20, y + 33);
    }

    private void renderImprinterRecipe(GuiGraphics graphics, int centerX, int y) {
        this.renderRecipeTitle(graphics, "Imprinter Recipe", centerX, y);
        ItemStack[][] recipe = new ItemStack[3][3];
        recipe[0][0] = new ItemStack((ItemLike)Items.IRON_INGOT);
        recipe[0][1] = new ItemStack((ItemLike)Items.PISTON);
        recipe[0][2] = new ItemStack((ItemLike)Items.IRON_INGOT);
        recipe[1][0] = new ItemStack((ItemLike)Items.REDSTONE_BLOCK);
        recipe[1][1] = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"hologenica", (String)"bioscanner")));
        recipe[1][2] = new ItemStack((ItemLike)Items.REDSTONE_BLOCK);
        recipe[2][0] = new ItemStack((ItemLike)Items.IRON_INGOT);
        recipe[2][1] = new ItemStack((ItemLike)Items.HOPPER);
        recipe[2][2] = new ItemStack((ItemLike)Items.IRON_INGOT);
        this.renderCraftingGrid(graphics, recipe, centerX, y + 15);
        ItemStack result = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"hologenica", (String)"imprinter")));
        graphics.renderItem(result, centerX + 20, y + 33);
    }

    private void renderNeurocellRecipe(GuiGraphics graphics, int centerX, int y) {
        this.renderRecipeTitle(graphics, "Neurocell Recipe", centerX, y);
        ItemStack[][] recipe = new ItemStack[3][3];
        recipe[0][0] = new ItemStack((ItemLike)Items.IRON_BLOCK);
        recipe[0][1] = new ItemStack((ItemLike)Items.GLASS_PANE);
        recipe[0][2] = new ItemStack((ItemLike)Items.IRON_BLOCK);
        recipe[1][0] = new ItemStack((ItemLike)Items.GLOWSTONE);
        recipe[1][1] = new ItemStack((ItemLike)Items.DIAMOND);
        recipe[1][2] = new ItemStack((ItemLike)Items.GLOWSTONE);
        recipe[2][0] = new ItemStack((ItemLike)Items.IRON_BLOCK);
        recipe[2][1] = new ItemStack((ItemLike)Items.NETHER_STAR);
        recipe[2][2] = new ItemStack((ItemLike)Items.IRON_BLOCK);
        this.renderCraftingGrid(graphics, recipe, centerX, y + 15);
        ItemStack result = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"hologenica", (String)"neurocell")));
        graphics.renderItem(result, centerX + 20, y + 33);
    }

    private void renderReformerRecipe(GuiGraphics graphics, int centerX, int y) {
        this.renderRecipeTitle(graphics, "Reformer Recipe", centerX, y);
        ItemStack[][] recipe = new ItemStack[3][3];
        recipe[0][0] = new ItemStack((ItemLike)Items.OBSIDIAN);
        recipe[0][1] = new ItemStack((ItemLike)Items.ENDER_PEARL);
        recipe[0][2] = new ItemStack((ItemLike)Items.OBSIDIAN);
        recipe[1][0] = new ItemStack((ItemLike)Items.DIAMOND);
        recipe[1][1] = new ItemStack((ItemLike)Items.ENDER_EYE);
        recipe[1][2] = new ItemStack((ItemLike)Items.DIAMOND);
        recipe[2][0] = new ItemStack((ItemLike)Items.OBSIDIAN);
        recipe[2][1] = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"hologenica", (String)"neurolink")));
        recipe[2][2] = new ItemStack((ItemLike)Items.OBSIDIAN);
        this.renderCraftingGrid(graphics, recipe, centerX, y + 15);
        ItemStack result = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"hologenica", (String)"reformer")));
        graphics.renderItem(result, centerX + 20, y + 33);
    }

    private void renderHologramRecipe(GuiGraphics graphics, int centerX, int y) {
        this.renderRecipeTitle(graphics, "Hologram Projector Recipe", centerX, y);
        ItemStack[][] recipe = new ItemStack[3][3];
        recipe[0][0] = new ItemStack((ItemLike)Items.GLASS_PANE);
        recipe[0][1] = new ItemStack((ItemLike)Items.GLOWSTONE);
        recipe[0][2] = new ItemStack((ItemLike)Items.GLASS_PANE);
        recipe[1][0] = new ItemStack((ItemLike)Items.REDSTONE);
        recipe[1][1] = new ItemStack((ItemLike)Items.DIAMOND);
        recipe[1][2] = new ItemStack((ItemLike)Items.REDSTONE);
        recipe[2][0] = new ItemStack((ItemLike)Items.IRON_BLOCK);
        recipe[2][1] = new ItemStack((ItemLike)Items.REDSTONE_BLOCK);
        recipe[2][2] = new ItemStack((ItemLike)Items.IRON_BLOCK);
        this.renderCraftingGrid(graphics, recipe, centerX, y + 15);
        ItemStack result = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"hologenica", (String)"hologram")));
        graphics.renderItem(result, centerX + 20, y + 33);
    }

    private void renderTelepadRecipe(GuiGraphics graphics, int centerX, int y) {
        this.renderRecipeTitle(graphics, "Telepad Recipe", centerX, y);
        ItemStack[][] recipe = new ItemStack[3][3];
        recipe[0][0] = new ItemStack((ItemLike)Items.ENDER_PEARL);
        recipe[0][1] = new ItemStack((ItemLike)Items.DIAMOND);
        recipe[0][2] = new ItemStack((ItemLike)Items.ENDER_PEARL);
        recipe[1][0] = new ItemStack((ItemLike)Items.OBSIDIAN);
        recipe[1][1] = new ItemStack((ItemLike)Items.ENDER_EYE);
        recipe[1][2] = new ItemStack((ItemLike)Items.OBSIDIAN);
        recipe[2][0] = new ItemStack((ItemLike)Items.IRON_BLOCK);
        recipe[2][1] = new ItemStack((ItemLike)Items.REDSTONE_BLOCK);
        recipe[2][2] = new ItemStack((ItemLike)Items.IRON_BLOCK);
        this.renderCraftingGrid(graphics, recipe, centerX, y + 15);
        ItemStack result = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"hologenica", (String)"telepad")));
        graphics.renderItem(result, centerX + 20, y + 33);
    }

    private void renderManualRecipe(GuiGraphics graphics, int centerX, int y) {
        this.renderRecipeTitle(graphics, "Manual Recipe", centerX, y);
        ItemStack[][] recipe = new ItemStack[3][3];
        recipe[1][0] = new ItemStack((ItemLike)Items.PAPER);
        recipe[1][1] = new ItemStack((ItemLike)Items.BOOK);
        recipe[1][2] = new ItemStack((ItemLike)Items.PAPER);
        this.renderCraftingGrid(graphics, recipe, centerX, y + 15);
        ItemStack result = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"hologenica", (String)"manual")));
        graphics.renderItem(result, centerX + 20, y + 33);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

