/*
 * Decompiled with CFR 0.152.
 */
package com.modvane.hologenica.client.screen;

import com.modvane.hologenica.menu.NeurocellMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class NeurocellScreen
extends AbstractContainerScreen<NeurocellMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"hologenica", (String)"textures/gui/centrifuge.png");

    public NeurocellScreen(NeurocellMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageHeight = 166;
        this.inventoryLabelY = this.imageHeight - 94;
    }

    protected void renderBg(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        graphics.blit(TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
        if (((NeurocellMenu)this.menu).getBlockEntity() != null) {
            int progress = ((NeurocellMenu)this.menu).getBlockEntity().getCloningTime();
            int duration = ((NeurocellMenu)this.menu).getBlockEntity().getCloningDuration();
            if (progress > 0 && duration > 0) {
                int progressWidth = (int)(24.0f * (float)progress / (float)duration);
                graphics.blit(TEXTURE, x + 76, y + 55, 176, 0, progressWidth, 17);
            }
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(graphics, mouseX, mouseY, partialTick);
        super.render(graphics, mouseX, mouseY, partialTick);
        this.renderTooltip(graphics, mouseX, mouseY);
    }
}

