/*
 * Decompiled with CFR 0.152.
 */
package com.modvane.hologenica.client.screen;

import com.modvane.hologenica.client.screen.BaseModScreen;
import com.modvane.hologenica.menu.TelepadMenu;
import com.modvane.hologenica.network.SetTelepadNamePacket;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.neoforge.network.PacketDistributor;

public class TelepadScreen
extends BaseModScreen<TelepadMenu> {
    private static final int TEXTFIELD_HEIGHT = 20;
    private static final int SPACING = 6;
    private EditBox nameField;

    public TelepadScreen(TelepadMenu menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
    }

    @Override
    protected int calculateGuiHeight() {
        return 81;
    }

    protected void init() {
        super.init();
        int y = this.topPos + 10;
        int contentWidth = this.imageWidth - 20;
        Objects.requireNonNull(this.font);
        this.nameField = new EditBox(this.font, this.leftPos + 10, y += 9 + 6, contentWidth, 20, (Component)Component.translatable((String)"gui.hologenica.telepad_name"));
        this.nameField.setMaxLength(32);
        String currentName = ((TelepadMenu)this.menu).getBlockEntity() != null ? ((TelepadMenu)this.menu).getBlockEntity().getTelepadName() : "";
        this.nameField.setValue(currentName);
        this.setInitialFocus((GuiEventListener)this.nameField);
        this.addRenderableWidget((GuiEventListener)this.nameField);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.hologenica.save"), button -> this.saveNameToServer()).bounds(this.leftPos + 10, y += 26, contentWidth, 20).build());
    }

    private void saveNameToServer() {
        String name = this.nameField.getValue();
        PacketDistributor.sendToServer((CustomPacketPayload)new SetTelepadNamePacket(((TelepadMenu)this.menu).getPos(), name), (CustomPacketPayload[])new CustomPacketPayload[0]);
        if (this.minecraft != null && this.minecraft.player != null) {
            this.minecraft.player.closeContainer();
        }
    }

    protected void renderBg(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        graphics.fill(this.leftPos, this.topPos, this.leftPos + this.imageWidth, this.topPos + this.imageHeight, -1072689136);
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.drawString(this.font, (Component)Component.translatable((String)"gui.hologenica.telepad_name_label"), 10, 10, 0xFFFFFF, false);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.nameField != null && this.nameField.isFocused()) {
            if (this.nameField.keyPressed(keyCode, scanCode, modifiers)) {
                return true;
            }
            if (keyCode != 256) {
                return true;
            }
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char codePoint, int modifiers) {
        if (this.nameField != null && this.nameField.isFocused()) {
            return this.nameField.charTyped(codePoint, modifiers);
        }
        return super.charTyped(codePoint, modifiers);
    }

    public void resize(Minecraft minecraft, int width, int height) {
        String currentValue = this.nameField.getValue();
        super.resize(minecraft, width, height);
        this.nameField.setValue(currentValue);
    }
}

