/*
 * Decompiled with CFR 0.152.
 */
package com.modvane.hologenica.entity;

import com.modvane.hologenica.menu.PlayerCloneMenu;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class PlayerCloneEntity
extends TamableAnimal {
    private static final EntityDataAccessor<Optional<UUID>> PLAYER_UUID = SynchedEntityData.defineId(PlayerCloneEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Boolean> IS_FOLLOWING = SynchedEntityData.defineId(PlayerCloneEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private String ownerName = "";

    public PlayerCloneEntity(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
        this.setTame(false, false);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(PLAYER_UUID, Optional.empty());
        builder.define(IS_FOLLOWING, (Object)false);
    }

    public void setOwnerName(String name) {
        this.ownerName = name;
        this.setCustomName((Component)Component.literal((String)name));
        this.setCustomNameVisible(true);
    }

    public void setPlayerUUID(UUID uuid) {
        this.entityData.set(PLAYER_UUID, Optional.ofNullable(uuid));
    }

    public UUID getPlayerUUID() {
        return ((Optional)this.entityData.get(PLAYER_UUID)).orElse(null);
    }

    public String getStoredOwnerName() {
        return this.ownerName;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(2, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.2, 2.0f, 5.0f));
        this.goalSelector.addGoal(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public boolean isFood(ItemStack stack) {
        return false;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob otherParent) {
        return null;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return TamableAnimal.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.FOLLOW_RANGE, 16.0);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (!this.level().isClientSide && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.openMenu(this.getMenuProvider());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
    }

    private MenuProvider getMenuProvider() {
        return new SimpleMenuProvider((containerId, playerInventory, player) -> new PlayerCloneMenu(containerId, playerInventory, this), (Component)Component.empty());
    }

    public void toggleFollowMode(Player player) {
        if (!this.isTame()) {
            this.setTame(true, true);
            this.setOwnerUUID(player.getUUID());
            this.setOrderedToSit(false);
            this.entityData.set(IS_FOLLOWING, (Object)true);
        } else {
            boolean currentlyFollowing = !this.isOrderedToSit();
            boolean newFollowingState = !currentlyFollowing;
            this.setOrderedToSit(!newFollowingState);
            this.entityData.set(IS_FOLLOWING, (Object)newFollowingState);
        }
    }

    public boolean isFollowing() {
        return (Boolean)this.entityData.get(IS_FOLLOWING);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        UUID playerUUID;
        super.addAdditionalSaveData(tag);
        if (!this.ownerName.isEmpty()) {
            tag.putString("OwnerName", this.ownerName);
        }
        if ((playerUUID = this.getPlayerUUID()) != null) {
            tag.putUUID("PlayerUUID", playerUUID);
        }
        tag.putBoolean("IsFollowing", this.isFollowing());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("OwnerName")) {
            this.ownerName = tag.getString("OwnerName");
            if (!this.ownerName.isEmpty()) {
                this.setCustomName((Component)Component.literal((String)this.ownerName));
                this.setCustomNameVisible(true);
            }
        }
        if (tag.hasUUID("PlayerUUID")) {
            this.setPlayerUUID(tag.getUUID("PlayerUUID"));
        }
        if (tag.contains("IsFollowing")) {
            this.entityData.set(IS_FOLLOWING, (Object)tag.getBoolean("IsFollowing"));
        }
    }
}

