/*
 * Decompiled with CFR 0.152.
 */
package com.modvane.hologenica.menu;

import com.modvane.hologenica.block.entity.HologramBlockEntity;
import com.modvane.hologenica.registry.HologenicaMenus;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class HologramMenu
extends AbstractContainerMenu {
    private final ContainerLevelAccess access;
    private final HologramBlockEntity blockEntity;
    private final ContainerData data;

    public HologramMenu(int containerId, Inventory playerInventory, HologramBlockEntity blockEntity) {
        super((MenuType)HologenicaMenus.HOLOGRAM.get(), containerId);
        if (blockEntity != null) {
            this.access = ContainerLevelAccess.create((Level)blockEntity.getLevel(), (BlockPos)blockEntity.getBlockPos());
            this.blockEntity = blockEntity;
        } else {
            this.access = ContainerLevelAccess.NULL;
            this.blockEntity = null;
        }
        this.data = new SimpleContainerData(3);
        this.addDataSlots(this.data);
    }

    public boolean clickMenuButton(Player player, int buttonId) {
        if (this.blockEntity != null) {
            if (buttonId == 0) {
                this.blockEntity.toggleTransparency();
                return true;
            }
            if (buttonId == 1) {
                this.blockEntity.toggleRotation();
                return true;
            }
            if (buttonId == 2) {
                this.blockEntity.cycleStyle();
                return true;
            }
            if (buttonId == 3) {
                this.blockEntity.setScanSize(32);
                return true;
            }
            if (buttonId == 4) {
                this.blockEntity.setScanSize(64);
                return true;
            }
            if (buttonId == 5) {
                this.blockEntity.setScanSize(128);
                return true;
            }
            if (buttonId == 6) {
                this.blockEntity.setBlockSize(1);
                return true;
            }
            if (buttonId == 7) {
                this.blockEntity.setBlockSize(3);
                return true;
            }
            if (buttonId == 8) {
                this.blockEntity.setBlockSize(9);
                return true;
            }
        }
        return false;
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        if (this.blockEntity != null) {
            this.data.set(0, this.blockEntity.isTransparentMode() ? 1 : 0);
            this.data.set(1, this.blockEntity.isRotationEnabled() ? 1 : 0);
            this.data.set(2, this.blockEntity.getRenderStyle().ordinal());
        }
    }

    public boolean isTransparentMode() {
        return this.data.get(0) == 1;
    }

    public boolean isRotationEnabled() {
        return this.data.get(1) == 1;
    }

    public String getRenderStyleName() {
        int styleIndex = this.data.get(2);
        return styleIndex == 0 ? "Classic" : "Realistic";
    }

    public boolean stillValid(Player player) {
        return this.blockEntity != null && HologramMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)this.blockEntity.getBlockState().getBlock());
    }

    public HologramBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        return ItemStack.EMPTY;
    }
}

