/*
 * Decompiled with CFR 0.152.
 */
package com.modvane.hologenica.menu;

import com.modvane.hologenica.block.entity.NeurocellBlockEntity;
import com.modvane.hologenica.registry.HologenicaMenus;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class NeurocellMenu
extends AbstractContainerMenu {
    private final Container container;
    private NeurocellBlockEntity blockEntity;

    public NeurocellMenu(int containerId, Inventory playerInventory, NeurocellBlockEntity blockEntity) {
        super((MenuType)HologenicaMenus.NEUROCELL.get(), containerId);
        this.container = blockEntity.getInventory();
        this.blockEntity = blockEntity;
        this.addSlot(new Slot(this.container, 0, 80, 35));
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.addSlot(new Slot((Container)playerInventory, col, 8 + col * 18, 142));
        }
    }

    public NeurocellMenu(int containerId, Inventory playerInventory, Container container) {
        super((MenuType)HologenicaMenus.NEUROCELL.get(), containerId);
        this.container = container;
        this.blockEntity = null;
        this.addSlot(new Slot(container, 0, 80, 35));
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.addSlot(new Slot((Container)playerInventory, col, 8 + col * 18, 142));
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack slotItem = slot.getItem();
            itemstack = slotItem.copy();
            if (index == 0 ? !this.moveItemStackTo(slotItem, 1, 37, true) : !this.moveItemStackTo(slotItem, 0, 1, false)) {
                return ItemStack.EMPTY;
            }
            if (slotItem.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public boolean stillValid(Player player) {
        return this.container.stillValid(player);
    }

    public NeurocellBlockEntity getBlockEntity() {
        return this.blockEntity;
    }
}

