/*
 * Decompiled with CFR 0.152.
 */
package com.modvane.hologenica.menu;

import com.modvane.hologenica.entity.PlayerCloneEntity;
import com.modvane.hologenica.registry.HologenicaMenus;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;

public class PlayerCloneMenu
extends AbstractContainerMenu {
    private final PlayerCloneEntity cloneEntity;
    private final ContainerData data;

    public PlayerCloneMenu(int containerId, Inventory playerInventory, PlayerCloneEntity cloneEntity) {
        super((MenuType)HologenicaMenus.PLAYER_CLONE.get(), containerId);
        this.cloneEntity = cloneEntity;
        this.data = new SimpleContainerData(1);
        this.addDataSlots(this.data);
    }

    public boolean clickMenuButton(Player player, int buttonId) {
        if (this.cloneEntity != null && buttonId == 0) {
            this.cloneEntity.toggleFollowMode(player);
            return true;
        }
        return false;
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        if (this.cloneEntity != null) {
            this.data.set(0, this.cloneEntity.isFollowing() ? 1 : 0);
        }
    }

    public boolean isFollowing() {
        return this.data.get(0) == 1;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        return ItemStack.EMPTY;
    }

    public boolean stillValid(Player player) {
        return this.cloneEntity != null && this.cloneEntity.isAlive() && player.distanceToSqr((Entity)this.cloneEntity) <= 64.0;
    }

    public PlayerCloneEntity getCloneEntity() {
        return this.cloneEntity;
    }
}

