/*
 * Decompiled with CFR 0.152.
 */
package com.modvane.hologenica.menu;

import com.modvane.hologenica.block.entity.TelepadBlockEntity;
import com.modvane.hologenica.registry.HologenicaBlocks;
import com.modvane.hologenica.registry.HologenicaMenus;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TelepadMenu
extends AbstractContainerMenu {
    private final ContainerLevelAccess access;
    private final BlockPos pos;
    private final Player player;

    public TelepadMenu(int containerId, Inventory playerInventory, TelepadBlockEntity blockEntity) {
        super((MenuType)HologenicaMenus.TELEPAD.get(), containerId);
        this.player = playerInventory.player;
        if (blockEntity != null) {
            this.access = ContainerLevelAccess.create((Level)blockEntity.getLevel(), (BlockPos)blockEntity.getBlockPos());
            this.pos = blockEntity.getBlockPos();
        } else {
            this.access = ContainerLevelAccess.NULL;
            this.pos = BlockPos.ZERO;
        }
    }

    public TelepadMenu(int containerId, Inventory playerInventory, BlockPos pos) {
        super((MenuType)HologenicaMenus.TELEPAD.get(), containerId);
        this.player = playerInventory.player;
        this.access = ContainerLevelAccess.NULL;
        this.pos = pos;
    }

    public boolean stillValid(Player player) {
        return TelepadMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)HologenicaBlocks.TELEPAD.get()));
    }

    public TelepadBlockEntity getBlockEntity() {
        BlockEntity be;
        if (this.player != null && this.player.level() != null && (be = this.player.level().getBlockEntity(this.pos)) instanceof TelepadBlockEntity) {
            TelepadBlockEntity telepad = (TelepadBlockEntity)be;
            return telepad;
        }
        return null;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        return ItemStack.EMPTY;
    }
}

