/*
 * Decompiled with CFR 0.152.
 */
package com.modvane.hologenica.network;

import com.modvane.hologenica.HologenicaMod;
import com.modvane.hologenica.block.entity.TelepadBlockEntity;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SetTelepadNamePacket(BlockPos pos, String name) implements CustomPacketPayload
{
    private static final int MAX_TELEPAD_NAME_LENGTH = 32;
    private static final double MAX_INTERACTION_DISTANCE = 64.0;
    public static final CustomPacketPayload.Type<SetTelepadNamePacket> TYPE = new CustomPacketPayload.Type(HologenicaMod.id("set_telepad_name"));
    public static final StreamCodec<ByteBuf, SetTelepadNamePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, SetTelepadNamePacket::pos, (StreamCodec)ByteBufCodecs.STRING_UTF8, SetTelepadNamePacket::name, SetTelepadNamePacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(SetTelepadNamePacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)patt0$temp;
            BlockEntity blockEntity = player.level().getBlockEntity(packet.pos());
            if (!(blockEntity instanceof TelepadBlockEntity)) {
                return;
            }
            TelepadBlockEntity telepad = (TelepadBlockEntity)blockEntity;
            double distance = player.distanceToSqr((double)packet.pos().getX(), (double)packet.pos().getY(), (double)packet.pos().getZ());
            if (distance >= 64.0) {
                return;
            }
            String sanitizedName = SetTelepadNamePacket.validateAndSanitizeName(packet.name());
            telepad.setTelepadName(sanitizedName);
        });
    }

    private static String validateAndSanitizeName(String name) {
        if (name == null) {
            return "";
        }
        String sanitized = name.trim();
        if (sanitized.length() > 32) {
            sanitized = sanitized.substring(0, 32);
        }
        sanitized = sanitized.replaceAll("\\p{Cntrl}", "");
        return sanitized;
    }
}

