/*
 * Decompiled with CFR 0.152.
 */
package com.modvane.hologenica.util;

import com.modvane.hologenica.block.NeurocellBlock;
import com.modvane.hologenica.block.NeurolinkBlock;
import com.modvane.hologenica.block.entity.NeurocellBlockEntity;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class NeurocellConnector {
    @Nullable
    public static NeurocellBlockEntity findConnectedNeurocell(Level level, BlockPos sourcePos, Predicate<NeurocellBlockEntity> filter) {
        if (level == null) {
            return null;
        }
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        int neurolinkCount = 0;
        queue.add(sourcePos);
        visited.add(sourcePos);
        while (!queue.isEmpty() && neurolinkCount <= 16) {
            BlockPos current = (BlockPos)queue.poll();
            for (Direction dir : Direction.values()) {
                BlockPos neighborPos = current.relative(dir);
                if (visited.contains(neighborPos)) continue;
                BlockState neighborState = level.getBlockState(neighborPos);
                if (neighborState.getBlock() instanceof NeurocellBlock) {
                    NeurocellBlockEntity neurocell;
                    BlockEntity be = level.getBlockEntity(neighborPos);
                    if (!(be instanceof NeurocellBlockEntity) || !(neurocell = (NeurocellBlockEntity)be).acceptsConnectionFrom(dir.getOpposite()) || !filter.test(neurocell)) continue;
                    return neurocell;
                }
                visited.add(neighborPos);
                if (!(neighborState.getBlock() instanceof NeurolinkBlock)) continue;
                queue.add(neighborPos);
                ++neurolinkCount;
            }
        }
        return null;
    }

    @Nullable
    public static NeurocellBlockEntity findConnectedNeurocellFromBack(Level level, BlockPos sourcePos, Predicate<NeurocellBlockEntity> filter) {
        return NeurocellConnector.findConnectedNeurocell(level, sourcePos, filter);
    }
}

