/*
 * Decompiled with CFR 0.152.
 */
package com.modvane.hologenica.world;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

public class TelepadRegistry
extends SavedData {
    private static final String DATA_NAME = "hologenica_telepad_registry";
    private final Map<String, List<TelepadLocation>> telepads = new HashMap<String, List<TelepadLocation>>();

    public TelepadRegistry() {
    }

    public TelepadRegistry(CompoundTag tag, HolderLookup.Provider registries) {
        ListTag list = tag.getList("Telepads", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag entry = list.getCompound(i);
            String name = entry.getString("Name");
            ListTag locations = entry.getList("Locations", 10);
            ArrayList<TelepadLocation> locationList = new ArrayList<TelepadLocation>();
            for (int j = 0; j < locations.size(); ++j) {
                CompoundTag locTag = locations.getCompound(j);
                String dimensionStr = locTag.getString("Dimension");
                ResourceLocation dimRL = ResourceLocation.parse((String)dimensionStr);
                ResourceKey dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)dimRL);
                BlockPos pos = new BlockPos(locTag.getInt("X"), locTag.getInt("Y"), locTag.getInt("Z"));
                locationList.add(new TelepadLocation((ResourceKey<Level>)dimension, pos));
            }
            this.telepads.put(name, locationList);
        }
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider registries) {
        ListTag list = new ListTag();
        for (Map.Entry<String, List<TelepadLocation>> entry : this.telepads.entrySet()) {
            CompoundTag telepadEntry = new CompoundTag();
            telepadEntry.putString("Name", entry.getKey());
            ListTag locations = new ListTag();
            for (TelepadLocation loc : entry.getValue()) {
                CompoundTag locTag = new CompoundTag();
                locTag.putString("Dimension", loc.dimension().location().toString());
                locTag.putInt("X", loc.pos().getX());
                locTag.putInt("Y", loc.pos().getY());
                locTag.putInt("Z", loc.pos().getZ());
                locations.add((Object)locTag);
            }
            telepadEntry.put("Locations", (Tag)locations);
            list.add((Object)telepadEntry);
        }
        tag.put("Telepads", (Tag)list);
        return tag;
    }

    public static TelepadRegistry get(MinecraftServer server) {
        return (TelepadRegistry)server.overworld().getDataStorage().computeIfAbsent(new SavedData.Factory(TelepadRegistry::new, TelepadRegistry::new, null), DATA_NAME);
    }

    public void registerTelepad(String name, ResourceKey<Level> dimension, BlockPos pos) {
        if (name.isEmpty()) {
            return;
        }
        this.telepads.computeIfAbsent(name, k -> new ArrayList());
        TelepadLocation newLoc = new TelepadLocation(dimension, pos);
        List<TelepadLocation> locations = this.telepads.get(name);
        locations.removeIf(loc -> loc.dimension().equals((Object)dimension) && loc.pos().equals((Object)pos));
        locations.add(newLoc);
        this.setDirty();
    }

    public void unregisterTelepad(ResourceKey<Level> dimension, BlockPos pos) {
        for (List<TelepadLocation> locations : this.telepads.values()) {
            locations.removeIf(loc -> loc.dimension().equals((Object)dimension) && loc.pos().equals((Object)pos));
        }
        this.telepads.values().removeIf(List::isEmpty);
        this.setDirty();
    }

    public List<TelepadLocation> findTelepads(String name) {
        return this.telepads.getOrDefault(name, Collections.emptyList());
    }

    public record TelepadLocation(ResourceKey<Level> dimension, BlockPos pos) {
    }
}

