/*
 * Decompiled with CFR 0.152.
 */
package dev.thomas.deathpunishment;

import dev.thomas.deathpunishment.EventHandler;
import dev.thomas.deathpunishment.compat.ModCompat;
import dev.thomas.deathpunishment.config.Configuration;
import dev.thomas.deathpunishment.config.ModConfigScreen;
import dev.thomas.deathpunishment.integration.corpse.CorpseInteractionHandler;
import dev.thomas.deathpunishment.integration.playerrevive.PlayerReviveEventHandler;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="punishment_for_death")
public class DeathPunishment {
    public static final String MOD_ID = "punishment_for_death";

    public DeathPunishment() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Configuration.CONFIG, "tfc_punishment_for_death-common.toml");
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::onClientSetup);
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        forgeEventBus.register((Object)new EventHandler());
        if (ModCompat.isCorpseInstalled()) {
            try {
                forgeEventBus.register((Object)new CorpseInteractionHandler());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (ModCompat.isPlayerReviveInstalled()) {
            try {
                forgeEventBus.register((Object)new PlayerReviveEventHandler());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            if (FMLJavaModLoadingContext.get().getModEventBus() != null) {
                this.registerConfigScreen();
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerConfigScreen() {
        ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((client, parent) -> ModConfigScreen.createScreen(parent)));
    }

    private void setup(FMLCommonSetupEvent event) {
    }
}

