/*
 * Decompiled with CFR 0.152.
 */
package dev.thomas.deathpunishment;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class DeathTimerStorage
extends SavedData {
    private final Map<UUID, Long> corpseTimers = new HashMap<UUID, Long>();

    public static DeathTimerStorage get(ServerLevel level) {
        return (DeathTimerStorage)level.m_8895_().m_164861_(DeathTimerStorage::load, DeathTimerStorage::new, "deathpunishment_timers");
    }

    public void addTimer(UUID corpseId) {
        this.corpseTimers.put(corpseId, System.currentTimeMillis());
        this.m_77762_();
    }

    public void removeTimer(UUID corpseId) {
        this.corpseTimers.remove(corpseId);
        this.m_77762_();
    }

    private void validateTimers(int cooldownMinutes) {
        long currentTime = System.currentTimeMillis();
        long cooldownMillis = (long)cooldownMinutes * 60000L;
        this.corpseTimers.entrySet().removeIf(entry -> {
            boolean expired;
            boolean bl = expired = currentTime - (Long)entry.getValue() >= cooldownMillis;
            if (expired) {
                this.m_77762_();
            }
            return expired;
        });
    }

    public boolean canInteract(UUID corpseId, int cooldownMinutes) {
        this.validateTimers(cooldownMinutes);
        return !this.corpseTimers.containsKey(corpseId);
    }

    public int getRemainingMinutes(UUID corpseId, int cooldownMinutes) {
        if (!this.corpseTimers.containsKey(corpseId)) {
            return 0;
        }
        long cooldownMillis = (long)cooldownMinutes * 60000L;
        long elapsed = System.currentTimeMillis() - this.corpseTimers.get(corpseId);
        return (int)Math.ceil((double)(cooldownMillis - elapsed) / 60000.0);
    }

    public static DeathTimerStorage load(CompoundTag nbt) {
        DeathTimerStorage data = new DeathTimerStorage();
        ListTag list = nbt.m_128437_("timers", 10);
        for (Tag tag : list) {
            CompoundTag entry = (CompoundTag)tag;
            UUID corpseId = entry.m_128342_("corpseId");
            long timestamp = entry.m_128454_("timestamp");
            data.corpseTimers.put(corpseId, timestamp);
        }
        return data;
    }

    @NotNull
    public CompoundTag m_7176_(CompoundTag nbt) {
        ListTag list = new ListTag();
        this.corpseTimers.forEach((corpseId, timestamp) -> {
            CompoundTag entry = new CompoundTag();
            entry.m_128362_("corpseId", corpseId);
            entry.m_128356_("timestamp", timestamp.longValue());
            list.add((Object)entry);
        });
        nbt.m_128365_("timers", (Tag)list);
        return nbt;
    }
}

