/*
 * Decompiled with CFR 0.152.
 */
package dev.thomas.deathpunishment;

import dev.thomas.deathpunishment.config.Configuration;
import dev.thomas.deathpunishment.integration.tfc.TFCIntegration;
import dev.thomas.deathpunishment.util.PlayerDataStorage;
import net.dries007.tfc.common.capabilities.food.TFCFoodData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="punishment_for_death")
public class EventHandler {
    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        try {
            PlayerDataStorage.storePlayerData(player, event.getSource());
        }
        catch (Exception e) {
            System.err.println("Error storing player data on death: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (player2.m_5833_() || player2.m_7500_()) {
            return;
        }
        player2.m_20194_().execute(() -> {
            try {
                EventHandler.applyRespawnSettings(player2);
                EventHandler.applyRespawnEffects(player2);
            }
            catch (Exception e) {
                System.err.println("Error applying respawn settings: " + e.getMessage());
                e.printStackTrace();
            }
        });
    }

    public static void applyRespawnSettings(ServerPlayer player) {
        if (player == null || player.m_213877_()) {
            return;
        }
        PlayerDataStorage.PlayerSnapshot snapshot = PlayerDataStorage.getSnapshot(player.m_20148_());
        if (snapshot == null) {
            return;
        }
        try {
            if (snapshot.getFood() < 0 || snapshot.getFood() > 20) {
                player.m_36324_().m_38705_(4);
                player.m_36324_().m_38717_(0.0f);
                return;
            }
            Configuration.HungerMode hungerMode = (Configuration.HungerMode)((Object)Configuration.HUNGER_MODE.get());
            switch (hungerMode) {
                case KEEP: {
                    if (snapshot.diedFromStarvation()) {
                        player.m_36324_().m_38705_(3);
                        player.m_36324_().m_38717_(0.0f);
                        break;
                    }
                    player.m_36324_().m_38705_(snapshot.getFood());
                    player.m_36324_().m_38717_(snapshot.getSaturation());
                    break;
                }
                case MANUAL: {
                    int foodLevel = (Integer)Configuration.FOOD_LEVEL.get();
                    player.m_36324_().m_38705_(foodLevel);
                    player.m_36324_().m_38717_(0.0f);
                    break;
                }
                case TFC: {
                    player.m_36324_().m_38705_(4);
                    player.m_36324_().m_38717_(0.0f);
                }
            }
            FoodData foodData = player.m_36324_();
            if (foodData instanceof TFCFoodData) {
                TFCFoodData tfcFood = (TFCFoodData)foodData;
                if (snapshot.getThirst() < 0.0f || snapshot.getThirst() > 100.0f) {
                    tfcFood.setThirst(100.0f);
                } else {
                    switch ((Configuration.ThirstMode)((Object)Configuration.THIRST_MODE.get())) {
                        case KEEP: {
                            if (snapshot.diedFromThirst()) {
                                tfcFood.setThirst(20.0f);
                                break;
                            }
                            tfcFood.setThirst(snapshot.getThirst());
                            break;
                        }
                        case MANUAL: {
                            tfcFood.setThirst((float)((Integer)Configuration.THIRST_LEVEL.get()).intValue());
                            break;
                        }
                    }
                }
            }
            switch ((Configuration.HealthMode)((Object)Configuration.HEALTH_MODE.get())) {
                case MANUAL: {
                    player.m_21153_((float)((Integer)Configuration.HEALTH.get()).intValue());
                    break;
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error applying respawn settings for player " + player.m_7755_().getString() + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static void applyRespawnEffects(ServerPlayer player) {
        if (player == null || player.m_213877_()) {
            return;
        }
        try {
            int amplifier = (Integer)Configuration.EFFECT_AMPLIFIER.get();
            int tick = 20;
            EventHandler.applyEffect(player, TFCIntegration.THIRST, (Integer)Configuration.THIRST_DURATION.get() * tick, amplifier);
            EventHandler.applyEffect(player, TFCIntegration.EXHAUSTED, (Integer)Configuration.EXHAUSTED_DURATION.get() * tick, amplifier);
            EventHandler.applyEffect(player, TFCIntegration.PINNED, (Integer)Configuration.PINNED_DURATION.get() * tick, amplifier);
            EventHandler.applyEffect(player, MobEffects.f_19610_, (Integer)Configuration.BLINDNESS_DURATION.get() * tick, amplifier);
            EventHandler.applyEffect(player, MobEffects.f_19604_, (Integer)Configuration.CONFUSION_DURATION.get() * tick, amplifier);
            EventHandler.applyEffect(player, MobEffects.f_19612_, (Integer)Configuration.HUNGER_DURATION.get() * tick, amplifier);
            EventHandler.applyEffect(player, MobEffects.f_19597_, (Integer)Configuration.MOVEMENT_DURATION.get() * tick, amplifier);
            EventHandler.applyEffect(player, MobEffects.f_216964_, (Integer)Configuration.DARKNESS_DURATION.get() * tick, amplifier);
        }
        catch (Exception e) {
            System.err.println("Error applying respawn effects for player " + player.m_7755_().getString() + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void applyEffect(ServerPlayer player, MobEffect effect, int duration, int amplifier) {
        if (player == null || player.m_213877_() || effect == null || duration <= 0) {
            return;
        }
        try {
            player.m_7292_(new MobEffectInstance(effect, duration, amplifier, false, true, true));
        }
        catch (Exception e) {
            System.err.println("Error applying effect " + effect.m_19481_() + " for player " + player.m_7755_().getString() + ": " + e.getMessage());
        }
    }
}

