/*
 * Decompiled with CFR 0.152.
 */
package dev.thomas.deathpunishment.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class Configuration {
    public static final ForgeConfigSpec CONFIG;
    public static ForgeConfigSpec.EnumValue<HungerMode> HUNGER_MODE;
    public static ForgeConfigSpec.EnumValue<ThirstMode> THIRST_MODE;
    public static ForgeConfigSpec.EnumValue<HealthMode> HEALTH_MODE;
    public static ForgeConfigSpec.IntValue FOOD_LEVEL;
    public static ForgeConfigSpec.IntValue THIRST_LEVEL;
    public static ForgeConfigSpec.IntValue HEALTH;
    public static ForgeConfigSpec.IntValue EFFECT_AMPLIFIER;
    public static ForgeConfigSpec.IntValue CORPSE_COOLDOWN;
    public static ForgeConfigSpec.IntValue THIRST_DURATION;
    public static ForgeConfigSpec.IntValue EXHAUSTED_DURATION;
    public static ForgeConfigSpec.IntValue PINNED_DURATION;
    public static ForgeConfigSpec.IntValue BLINDNESS_DURATION;
    public static ForgeConfigSpec.IntValue CONFUSION_DURATION;
    public static ForgeConfigSpec.IntValue HUNGER_DURATION;
    public static ForgeConfigSpec.IntValue MOVEMENT_DURATION;
    public static ForgeConfigSpec.IntValue DARKNESS_DURATION;

    private static void setupConfig(ForgeConfigSpec.Builder builder) {
        builder.comment("General Settings").push("general");
        HUNGER_MODE = builder.comment("Hunger handling mode: TFC (default), MANUAL (set value), KEEP (preserve after death)").translation("config.deathpunishment.general.hunger_mode").defineEnum("hungerMode", (Enum)HungerMode.TFC);
        THIRST_MODE = builder.comment("Thirst handling mode: TFC (default), MANUAL (set value), KEEP (preserve after death)").translation("config.deathpunishment.general.thirst_mode").defineEnum("thirstMode", (Enum)ThirstMode.TFC);
        HEALTH_MODE = builder.comment("Health handling mode: TFC (default), MANUAL (set value)").translation("config.deathpunishment.general.health_mode").defineEnum("healthMode", (Enum)HealthMode.TFC);
        FOOD_LEVEL = builder.comment(new String[]{"Manual food level [1-20]", "Active only when hungerMode = MANUAL"}).translation("config.deathpunishment.general.food_level").defineInRange("food_level", 6, 1, 20);
        THIRST_LEVEL = builder.comment(new String[]{"Manual thirst level [5-100]", "Active only when thirstMode = MANUAL"}).translation("config.deathpunishment.general.thirst_level").defineInRange("thirst_level", 25, 5, 100);
        HEALTH = builder.comment(new String[]{"Manual health value [1-100]", "Active only when healthMode = MANUAL"}).translation("config.deathpunishment.general.health").defineInRange("health", 10, 1, 100);
        builder.pop();
        builder.comment("Death Penalties").push("penalties");
        EFFECT_AMPLIFIER = builder.comment("Base level for all applied effects (0 = I level, max 5)").translation("config.deathpunishment.penalties.effect_amplifier").defineInRange("effect_amplifier", 0, 0, 5);
        CORPSE_COOLDOWN = builder.comment("Cooldown in minutes before corpse interaction (0-60)").translation("config.deathpunishment.penalties.corpse_cooldown").defineInRange("corpse_cooldown", 1, 0, 60);
        THIRST_DURATION = builder.comment("Thirst effect duration in seconds (0-600)").translation("config.deathpunishment.penalties.thirst_duration").defineInRange("thirst_duration", 30, 0, 600);
        EXHAUSTED_DURATION = builder.comment("Exhaustion effect duration in seconds (0-600)").translation("config.deathpunishment.penalties.exhausted_duration").defineInRange("exhausted_duration", 60, 0, 600);
        PINNED_DURATION = builder.comment("Pinned effect duration in seconds (0-600)").translation("config.deathpunishment.penalties.pinned_duration").defineInRange("pinned_duration", 5, 0, 600);
        BLINDNESS_DURATION = builder.comment("Blindness effect duration in seconds (0-600)").translation("config.deathpunishment.penalties.blindness_duration").defineInRange("blindness_duration", 10, 0, 600);
        CONFUSION_DURATION = builder.comment("Nausea effect duration in seconds (0-600)").translation("config.deathpunishment.penalties.confusion_duration").defineInRange("confusion_duration", 15, 0, 600);
        HUNGER_DURATION = builder.comment("Hunger effect duration in seconds (0-600)").translation("config.deathpunishment.penalties.hunger_duration").defineInRange("hunger_duration", 30, 0, 600);
        MOVEMENT_DURATION = builder.comment("Slowness effect duration in seconds (0-600)").translation("config.deathpunishment.penalties.movement_duration").defineInRange("movement_duration", 30, 0, 600);
        DARKNESS_DURATION = builder.comment("Darkness effect duration in seconds (0-600)").translation("config.deathpunishment.penalties.darkness_duration").defineInRange("darkness_duration", 20, 0, 600);
        builder.pop();
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        Configuration.setupConfig(builder);
        CONFIG = builder.build();
    }

    public static enum HungerMode {
        TFC,
        MANUAL,
        KEEP;

    }

    public static enum ThirstMode {
        TFC,
        MANUAL,
        KEEP;

    }

    public static enum HealthMode {
        TFC,
        MANUAL;

    }
}

