/*
 * Decompiled with CFR 0.152.
 */
package dev.thomas.deathpunishment.integration.corpse;

import de.maxhenkel.corpse.entities.CorpseEntity;
import dev.thomas.deathpunishment.DeathTimerStorage;
import dev.thomas.deathpunishment.config.Configuration;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CorpseInteractionHandler {
    @SubscribeEvent
    public void onCorpseSpawn(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof CorpseEntity) {
            CorpseEntity corpse = (CorpseEntity)entity;
            entity = event.getLevel();
            if (entity instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)entity;
                DeathTimerStorage storage = DeathTimerStorage.get(level);
                storage.addTimer(corpse.m_20148_());
            }
        }
    }

    @SubscribeEvent
    public void onCorpseDespawn(EntityLeaveLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof CorpseEntity) {
            CorpseEntity corpse = (CorpseEntity)entity;
            entity = event.getLevel();
            if (entity instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)entity;
                DeathTimerStorage storage = DeathTimerStorage.get(level);
                storage.removeTimer(corpse.m_20148_());
            }
        }
    }

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent.EntityInteract event) {
        CorpseEntity corpse;
        Entity entity;
        ServerLevel level;
        block6: {
            block5: {
                Level level2 = event.getLevel();
                if (!(level2 instanceof ServerLevel)) {
                    return;
                }
                level = (ServerLevel)level2;
                entity = event.getTarget();
                if (!(entity instanceof CorpseEntity)) break block5;
                corpse = (CorpseEntity)entity;
                entity = event.getEntity();
                if (entity instanceof ServerPlayer) break block6;
            }
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        DeathTimerStorage storage = DeathTimerStorage.get(level);
        int cooldown = (Integer)Configuration.CORPSE_COOLDOWN.get();
        UUID corpseId = corpse.m_20148_();
        if (!storage.canInteract(corpse.m_20148_(), cooldown)) {
            int remaining = storage.getRemainingMinutes(corpseId, cooldown);
            player.m_240418_((Component)Component.m_237110_((String)"message.deathpunishment.corpse_cooldown", (Object[])new Object[]{remaining}).m_130940_(ChatFormatting.RED), true);
            event.setCanceled(true);
        }
    }
}

