/*
 * Decompiled with CFR 0.152.
 */
package dev.thomas.deathpunishment.integration.playerrevive;

import dev.thomas.deathpunishment.EventHandler;
import dev.thomas.deathpunishment.compat.ModCompat;
import dev.thomas.deathpunishment.util.PlayerDataStorage;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class PlayerReviveEventHandler {
    @SubscribeEvent(priority=EventPriority.LOW)
    public void onPlayerRevived(Event event) {
        if (!ModCompat.isPlayerReviveInstalled()) {
            return;
        }
        if (!event.getClass().getName().equals("team.creative.playerrevive.api.event.PlayerRevivedEvent")) {
            return;
        }
        try {
            Object player = event.getClass().getMethod("getEntity", new Class[0]).invoke((Object)event, new Object[0]);
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (serverPlayer.m_213877_() || serverPlayer.m_5833_() || serverPlayer.m_7500_()) {
                return;
            }
            serverPlayer.m_20194_().execute(() -> {
                try {
                    EventHandler.applyRespawnSettings(serverPlayer);
                    EventHandler.applyRespawnEffects(serverPlayer);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onPlayerBleedOut(Event event) {
        if (!ModCompat.isPlayerReviveInstalled()) {
            return;
        }
        if (!event.getClass().getName().equals("team.creative.playerrevive.api.event.PlayerBleedOutEvent")) {
            return;
        }
        try {
            Object player = event.getClass().getMethod("getEntity", new Class[0]).invoke((Object)event, new Object[0]);
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (serverPlayer.m_213877_()) {
                return;
            }
            Object bleeding = event.getClass().getMethod("getBleeding", new Class[0]).invoke((Object)event, new Object[0]);
            Object source = bleeding.getClass().getMethod("getSource", Object.class).invoke(bleeding, serverPlayer.m_9236_().m_9598_());
            if (source instanceof DamageSource) {
                DamageSource damageSource = (DamageSource)source;
                PlayerDataStorage.storePlayerData(serverPlayer, damageSource);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

