/*
 * Decompiled with CFR 0.152.
 */
package dev.thomas.deathpunishment.util;

import dev.thomas.deathpunishment.integration.tfc.TFCIntegration;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.dries007.tfc.common.capabilities.food.TFCFoodData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.food.FoodData;

public class PlayerDataStorage {
    private static final Map<UUID, PlayerSnapshot> dataMap = new ConcurrentHashMap<UUID, PlayerSnapshot>();

    public static void storePlayerData(ServerPlayer player, DamageSource damageSource) {
        if (player == null || player.m_20148_() == null) {
            return;
        }
        try {
            int foodLevel;
            boolean isStarving = false;
            boolean isThirsty = false;
            if (damageSource != null) {
                isStarving = damageSource.m_276093_(DamageTypes.f_268441_) || TFCIntegration.isTFCStarvation(damageSource);
                isThirsty = TFCIntegration.isTFCThirst(damageSource) || damageSource.m_19385_().contains("thirst") || damageSource.m_19385_().contains("dehydration");
            }
            float thirst = 0.0f;
            FoodData foodData = player.m_36324_();
            if (foodData instanceof TFCFoodData) {
                TFCFoodData tfcFood = (TFCFoodData)foodData;
                try {
                    thirst = tfcFood.getThirst();
                    if (thirst <= 2.0f && !isThirsty) {
                        isThirsty = true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((foodLevel = player.m_36324_().m_38702_()) <= 1 && !isStarving) {
                isStarving = true;
            }
            PlayerSnapshot snapshot = new PlayerSnapshot(isStarving, isThirsty, foodLevel, player.m_36324_().m_38722_(), thirst, player.m_21223_());
            dataMap.put(player.m_20148_(), snapshot);
        }
        catch (Exception e) {
            System.err.println("Critical error storing player data: " + e.getMessage());
        }
    }

    public static PlayerSnapshot getSnapshot(UUID uuid) {
        if (uuid == null) {
            return null;
        }
        try {
            return dataMap.remove(uuid);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static PlayerSnapshot peekSnapshot(UUID uuid) {
        if (uuid == null) {
            return null;
        }
        try {
            return dataMap.get(uuid);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean hasSnapshot(UUID uuid) {
        if (uuid == null) {
            return false;
        }
        try {
            return dataMap.containsKey(uuid);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getSnapshotInfo(UUID uuid) {
        if (uuid == null) {
            return "No UUID";
        }
        try {
            PlayerSnapshot snapshot = dataMap.get(uuid);
            if (snapshot == null) {
                return "No snapshot found";
            }
            return String.format("Food: %d, Saturation: %.1f, Thirst: %.1f, Health: %.1f, Died from starvation: %s, Died from thirst: %s", snapshot.getFood(), Float.valueOf(snapshot.getSaturation()), Float.valueOf(snapshot.getThirst()), Float.valueOf(snapshot.getHealth()), snapshot.diedFromStarvation(), snapshot.diedFromThirst());
        }
        catch (Exception e) {
            return "Error getting snapshot info: " + e.getMessage();
        }
    }

    public static void clearOldData() {
        try {
            dataMap.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class PlayerSnapshot {
        private final boolean diedFromStarvation;
        private final boolean diedFromThirst;
        private final int food;
        private final float saturation;
        private final float thirst;
        private final float health;

        public PlayerSnapshot(boolean diedFromStarvation, boolean diedFromThirst, int food, float saturation, float thirst, float health) {
            this.diedFromStarvation = diedFromStarvation;
            this.diedFromThirst = diedFromThirst;
            this.food = food;
            this.saturation = saturation;
            this.thirst = thirst;
            this.health = health;
        }

        public boolean diedFromStarvation() {
            return this.diedFromStarvation;
        }

        public boolean diedFromThirst() {
            return this.diedFromThirst;
        }

        public int getFood() {
            return this.food;
        }

        public float getSaturation() {
            return this.saturation;
        }

        public float getThirst() {
            return this.thirst;
        }

        public float getHealth() {
            return this.health;
        }
    }
}

