/*
 * Decompiled with CFR 0.152.
 */
package com.ricardthegreat.holdmetight;

import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="holdmetight", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.ConfigValue<Double> MAX_HITBOX_SIZE = BUILDER.comment("The maximum scale a hitbox can be (8 or lower recommended for performance sake when larger)").define("maxHitboxScale", (Object)8.0);
    private static final ForgeConfigSpec.ConfigValue<Double> MAX_ENTITY_SIZE = BUILDER.comment("The maximum scale an entity can become, set to 0 for no cap (cannot be below 1)").define("maxEntityScale", (Object)0.0);
    private static final ForgeConfigSpec.ConfigValue<Double> PAPER_WINGS_MAX_SCALE = BUILDER.comment("the largest someone can be while wearing the paper wings item (an elytra in all ways that matter)").define("maxWingsScale", (Object)0.05);
    private static final ForgeConfigSpec.ConfigValue<Double> MIN_PARTICLE_SCALE = BUILDER.comment("the scale an entity should be before ambient particles are disabled on them").define("minParticleScale", (Object)0.5);
    private static final ForgeConfigSpec.ConfigValue<Boolean> MINING_SPEED_SCALE_LINK = BUILDER.comment("should a players mining speed be linked to their scale (faster for larger folk slower for smaller folk)").define("miningSpeedScaleLink", true);
    private static final ForgeConfigSpec.ConfigValue<Boolean> DAMAGE_TAKEN_SCALE_LINK = BUILDER.comment("should the damage a player takes be linked to their scale (less for larger folk more for smaller folk)").define("damageTakenScaleLink", true);
    private static final ForgeConfigSpec.ConfigValue<Boolean> PLAYER_CHAT_SCALE = BUILDER.comment("this isnt used currently").define("playerChatScale", false);
    static final ForgeConfigSpec SPEC = BUILDER.build();
    public static double maxHitboxScale;
    public static double maxEntityScale;
    public static double maxWingsScale;
    public static double minParticleScale;
    public static boolean playerChatScale;
    public static boolean miningSpeedScaleLink;
    public static boolean damageTakenScaleLink;

    private static boolean validateItemName(Object obj) {
        String itemName;
        return obj instanceof String && ForgeRegistries.ITEMS.containsKey(new ResourceLocation(itemName = (String)obj));
    }

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        maxHitboxScale = (Double)MAX_HITBOX_SIZE.get();
        maxEntityScale = (Double)MAX_ENTITY_SIZE.get() <= 0.0 ? Double.POSITIVE_INFINITY : ((Double)MAX_ENTITY_SIZE.get() < 1.0 ? 1.0 : (Double)MAX_ENTITY_SIZE.get());
        maxWingsScale = (Double)PAPER_WINGS_MAX_SCALE.get();
        minParticleScale = (Double)MIN_PARTICLE_SCALE.get();
        playerChatScale = (Boolean)PLAYER_CHAT_SCALE.get();
        miningSpeedScaleLink = (Boolean)MINING_SPEED_SCALE_LINK.get();
        damageTakenScaleLink = (Boolean)DAMAGE_TAKEN_SCALE_LINK.get();
    }
}

