/*
 * Decompiled with CFR 0.152.
 */
package com.ricardthegreat.holdmetight;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import com.ricardthegreat.holdmetight.Commands.TestingCommand;
import com.ricardthegreat.holdmetight.Config;
import com.ricardthegreat.holdmetight.events.ForgeModEvents;
import com.ricardthegreat.holdmetight.init.BlockEntityInit;
import com.ricardthegreat.holdmetight.init.BlockInit;
import com.ricardthegreat.holdmetight.init.CreativeTabInit;
import com.ricardthegreat.holdmetight.init.EffectsInit;
import com.ricardthegreat.holdmetight.init.EntityInit;
import com.ricardthegreat.holdmetight.init.ItemInit;
import com.ricardthegreat.holdmetight.init.PotionsInit;
import com.ricardthegreat.holdmetight.init.RecipeInit;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="holdmetight")
public class HoldMeTight {
    public static final String MODID = "holdmetight";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static boolean curiosInstalled;

    public HoldMeTight() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        curiosInstalled = ModList.get().isLoaded("curios");
        BlockInit.BLOCKS.register(modEventBus);
        BlockEntityInit.BLOCK_ENTITIES.register(modEventBus);
        ItemInit.ITEMS.register(modEventBus);
        CreativeTabInit.TABS.register(modEventBus);
        EntityInit.ENTITIES.register(modEventBus);
        EffectsInit.register(modEventBus);
        PotionsInit.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        RecipeInit.register();
    }

    @SubscribeEvent
    public void playerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        Player joiner = event.getEntity();
        Level level = joiner.m_9236_();
        MinecraftServer server = level.m_7654_();
        if (server != null) {
            ServerPlayer serverJoiner = server.m_6846_().m_11259_(joiner.m_20148_());
            ForgeModEvents.syncPlayerCapabilities(serverJoiner, server);
        }
    }

    @SubscribeEvent
    public void playerChangedDimensionEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player dimChangePlayer = event.getEntity();
        Level level = dimChangePlayer.m_9236_();
        MinecraftServer server = level.m_7654_();
        if (server != null) {
            ServerPlayer serverJoiner = server.m_6846_().m_11259_(dimChangePlayer.m_20148_());
            ForgeModEvents.syncPlayerCapabilities(serverJoiner, server);
        }
    }

    @SubscribeEvent
    public void registerServerCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        TestingCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
    }
}

