/*
 * Decompiled with CFR 0.152.
 */
package com.ricardthegreat.holdmetight.client.handlers;

import com.mojang.brigadier.CommandDispatcher;
import com.ricardthegreat.holdmetight.Commands.CustomCarryCommand;
import com.ricardthegreat.holdmetight.Commands.ResetCarriedCommand;
import com.ricardthegreat.holdmetight.Commands.ResetCarryingCommand;
import com.ricardthegreat.holdmetight.carry.PlayerCarry;
import com.ricardthegreat.holdmetight.carry.PlayerCarryProvider;
import com.ricardthegreat.holdmetight.client.ClientHooks;
import com.ricardthegreat.holdmetight.client.Keybindings;
import com.ricardthegreat.holdmetight.items.CollarItem;
import com.ricardthegreat.holdmetight.items.remotes.AbstractSizeRemoteItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.client.event.RenderNameTagEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

@Mod.EventBusSubscriber(modid="holdmetight", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientForgeHandler {
    private static final Component SHOULDER_KEY_PRESSED = Component.m_237115_((String)"message.holdmetight.shoulder_key_pressed");
    private static final Component CUSTOM_KEY_PRESSED = Component.m_237115_((String)"message.holdmetight.custom_key_pressed");
    private static final Component DEFAULT_KEY_PRESSED = Component.m_237115_((String)"message.holdmetight.default_key_pressed");

    @SubscribeEvent
    public static void RegisterClientCommandsEvent(RegisterClientCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        CustomCarryCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
        ResetCarriedCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
        ResetCarryingCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
    }

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        PlayerCarry playerCarry;
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer mcPlayer = minecraft.f_91074_;
        if (Keybindings.INSTANCE.shoulderCarryKey.m_90859_() && mcPlayer != null) {
            playerCarry = PlayerCarryProvider.getPlayerCarryCapability((Player)mcPlayer);
            if (playerCarry.getCarryPosition().posName != "shoulder") {
                playerCarry.setCarryPosition(false, 1);
                mcPlayer.m_5661_(SHOULDER_KEY_PRESSED, true);
            } else {
                playerCarry.setCarryPosition(false, 0);
                mcPlayer.m_5661_(DEFAULT_KEY_PRESSED, true);
            }
            playerCarry.setShouldSyncSimple(true);
        }
        if (Keybindings.INSTANCE.customCarryKey.m_90859_() && mcPlayer != null) {
            playerCarry = PlayerCarryProvider.getPlayerCarryCapability((Player)mcPlayer);
            if (playerCarry.getCarryPosition().posName == "shoulder" || playerCarry.getCarryPosition().posName == "hand") {
                playerCarry.setCarryPosition(true, 0);
                mcPlayer.m_5661_(CUSTOM_KEY_PRESSED, true);
            } else {
                playerCarry.setCarryPosition(false, 0);
                mcPlayer.m_5661_(DEFAULT_KEY_PRESSED, true);
            }
            playerCarry.setShouldSyncSimple(true);
        }
        if (Keybindings.INSTANCE.carryWheelKey.m_90859_() && mcPlayer != null && mcPlayer.m_9236_().f_46443_) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientHooks.openCarryPositionWheel((Player)mcPlayer));
        }
        if (Keybindings.INSTANCE.sizePrefsKey.m_90859_() && mcPlayer != null && mcPlayer.m_9236_().f_46443_) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientHooks.openSizePrefsScreen((Player)mcPlayer));
        }
        if (Keybindings.INSTANCE.carryScreenKey.m_90859_() && mcPlayer != null && mcPlayer.m_9236_().f_46443_) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientHooks.openCarryPositionScreen((Player)mcPlayer));
        }
    }

    @SubscribeEvent
    public static void interactLivingEntityEvent(PlayerInteractEvent.EntityInteract event) {
        Item item = event.getEntity().m_21120_(event.getHand()).m_41720_();
        Entity target = event.getTarget();
        if (item instanceof AbstractSizeRemoteItem) {
            AbstractSizeRemoteItem sizeRemote = (AbstractSizeRemoteItem)item;
            if (target instanceof LivingEntity && !event.getEntity().m_36335_().m_41519_(item)) {
                sizeRemote.m_6880_(event.getEntity().m_21120_(event.getHand()), event.getEntity(), (LivingEntity)target, event.getHand());
                if (event.isCancelable()) {
                    event.setCancellationResult(InteractionResult.SUCCESS);
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void renderNameTag(RenderNameTagEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> handler.getStacksHandler("collar").ifPresent(stacksHandler -> {
                IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                IDynamicStackHandler cosmeticStacksHandler = stacksHandler.getCosmeticStacks();
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    ItemStack stack = stackHandler.getStackInSlot(i);
                    if (!(stack.m_41720_() instanceof CollarItem)) continue;
                }
            }));
        }
    }
}

