/*
 * Decompiled with CFR 0.152.
 */
package com.ricardthegreat.holdmetight.client.handlers;

import com.ricardthegreat.holdmetight.HoldMeTight;
import com.ricardthegreat.holdmetight.client.Keybindings;
import com.ricardthegreat.holdmetight.client.models.ModModelLayers;
import com.ricardthegreat.holdmetight.client.models.RayGunProjectileModel;
import com.ricardthegreat.holdmetight.client.renderers.CollarRenderer;
import com.ricardthegreat.holdmetight.client.renderers.RayGunProjectileRenderer;
import com.ricardthegreat.holdmetight.client.renderers.WandProjectileRenderer;
import com.ricardthegreat.holdmetight.client.renderers.layers.PaperWingsLayer;
import com.ricardthegreat.holdmetight.init.EntityInit;
import com.ricardthegreat.holdmetight.init.ItemInit;
import com.ricardthegreat.holdmetight.items.CollarItem;
import java.util.Set;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;

@Mod.EventBusSubscriber(modid="holdmetight", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientModHandler {
    @SubscribeEvent
    public static void registerKeys(RegisterKeyMappingsEvent event) {
        event.register(Keybindings.INSTANCE.shoulderCarryKey);
        event.register(Keybindings.INSTANCE.customCarryKey);
        event.register(Keybindings.INSTANCE.carryWheelKey);
        event.register(Keybindings.INSTANCE.sizePrefsKey);
        event.register(Keybindings.INSTANCE.carryScreenKey);
    }

    @SubscribeEvent
    public static void RegisterLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(ModModelLayers.RAY_LAYER, RayGunProjectileModel::createBodyLayer);
    }

    @SubscribeEvent
    public static void onRegisterModelLayers(EntityRenderersEvent.AddLayers event) {
        Set skins = event.getSkins();
        for (String skin : skins) {
            try {
                LivingEntityRenderer renderer = event.getSkin(skin);
                if (renderer == null) continue;
                renderer.m_115326_(new PaperWingsLayer(renderer, event.getEntityModels()));
            }
            catch (Exception exception) {}
        }
    }

    @SubscribeEvent
    public static void onModelBakeEvent(ModelEvent.BakingCompleted event) {
        HoldMeTight.LOGGER.info("MODEL_BAKE_EVENT");
        ModelResourceLocation location = new ModelResourceLocation(new ResourceLocation("holdmetight", "collar_item"), "inventory");
        CollarRenderer renderer = new CollarRenderer((BakedModel)event.getModels().get(location));
        CuriosRendererRegistry.register((Item)((Item)ItemInit.COLLAR_ITEM.get()), () -> renderer);
    }

    @SubscribeEvent
    public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        CollarItem collar = (CollarItem)((Object)ItemInit.COLLAR_ITEM.get());
        event.register((itemStack, i) -> i == 0 ? collar.m_41121_(itemStack) : -1, new ItemLike[]{collar});
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        EntityRenderers.m_174036_((EntityType)((EntityType)EntityInit.RAY_GUN_PROJECTILE.get()), RayGunProjectileRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)EntityInit.WAND_PROJECTILE.get()), WandProjectileRenderer::new);
    }
}

