/*
 * Decompiled with CFR 0.152.
 */
package com.ricardthegreat.holdmetight.client.renderers;

import com.ricardthegreat.holdmetight.client.models.ArmorModel;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.world.entity.EquipmentSlot;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArmorRenderer<T extends ArmorModel> {
    private final T model;
    private static final ModelPart EMPTY_PART = new ModelPart(Collections.emptyList(), Collections.emptyMap());

    public ArmorRenderer(Supplier<LayerDefinition> supplier, Function<ModelPart, T> modelConstructor) {
        this.model = (ArmorModel)((Object)modelConstructor.apply(supplier.get().m_171564_()));
    }

    public ArmorRenderer<T> makeInvisible(boolean invisible) {
        ((ArmorModel)((Object)this.model)).makeInvisible(invisible);
        return this;
    }

    public ModelPart makeArmorParts(EquipmentSlot slot) {
        return new ModelPart(Collections.emptyList(), Map.of("head", slot == EquipmentSlot.HEAD ? ArmorRenderer.checkNonNull(((ArmorModel)((Object)this.model)).armorHead) : EMPTY_PART, "hat", EMPTY_PART, "body", slot == EquipmentSlot.CHEST ? ArmorRenderer.checkNonNull(((ArmorModel)((Object)this.model)).armorChest) : EMPTY_PART, "right_arm", slot == EquipmentSlot.CHEST ? ArmorRenderer.checkNonNull(((ArmorModel)((Object)this.model)).armorRightArm) : EMPTY_PART, "left_arm", slot == EquipmentSlot.CHEST ? ArmorRenderer.checkNonNull(((ArmorModel)((Object)this.model)).armorLeftArm) : EMPTY_PART, "right_leg", slot == EquipmentSlot.FEET ? ArmorRenderer.checkNonNull(((ArmorModel)((Object)this.model)).armorRightBoot) : (slot == EquipmentSlot.LEGS ? ArmorRenderer.checkNonNull(((ArmorModel)((Object)this.model)).armorRightLeg) : EMPTY_PART), "left_leg", slot == EquipmentSlot.FEET ? ArmorRenderer.checkNonNull(((ArmorModel)((Object)this.model)).armorLeftBoot) : (slot == EquipmentSlot.LEGS ? ArmorRenderer.checkNonNull(((ArmorModel)((Object)this.model)).armorLeftLeg) : EMPTY_PART)));
    }

    @NotNull
    private static ModelPart checkNonNull(@Nullable ModelPart part) {
        return part == null ? EMPTY_PART : part;
    }
}

