/*
 * Decompiled with CFR 0.152.
 */
package com.ricardthegreat.holdmetight.client.screens.remotes;

import com.ricardthegreat.holdmetight.client.screens.remotes.AbstractSizeRemoteScreen;
import com.ricardthegreat.holdmetight.network.PacketHandler;
import com.ricardthegreat.holdmetight.network.SEntityMultTargetScalePacket;
import com.ricardthegreat.holdmetight.network.SEntitySetTargetScalePacket;
import com.ricardthegreat.holdmetight.size.PlayerSizeProvider;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;

public class BasicSizeRemoteScreen
extends AbstractSizeRemoteScreen {
    protected static final Component TITLE = Component.m_237115_((String)"gui.holdmetight.size_remote_title");
    protected static final Component MULT_BUTTON = Component.m_237115_((String)"gui.holdmetight.size_remote.button.mult_button");
    protected static final Component SET_BUTTON = Component.m_237115_((String)"gui.holdmetight.size_remote.button.set_button");
    protected static final Component RESET_BUTTON = Component.m_237115_((String)"gui.holdmetight.size_remote.button.reset_button");
    protected static final Component MULT_BUTTON_TOOLTIP = Component.m_237115_((String)"gui.holdmetight.size_remote.button.mult_button_tooltip");
    protected static final Component SET_BUTTON_TOOLTIP = Component.m_237115_((String)"gui.holdmetight.size_remote.button.set_button_tooltip");
    protected static final Component RESET_BUTTON_TOOLTIP = Component.m_237115_((String)"gui.holdmetight.size_remote.button.reset_button_tooltip");
    protected static final Component CUSTOM_SCALE_FIELD = Component.m_237115_((String)"gui.holdmetight.size_remote.field.custom_scale_field");
    protected static final Component CUSTOM_SCALE_FIELD_TOOLTIP = Component.m_237115_((String)"gui.holdmetight.size_remote.field.custom_scale_field_tooltip");
    protected Button multButton;
    protected Button setButton;
    protected Button resetButton;
    protected EditBox customScaleField;

    public BasicSizeRemoteScreen(Player user, InteractionHand hand) {
        this(TITLE, user, hand, 176, 256);
    }

    public BasicSizeRemoteScreen(Component title, Player user, InteractionHand hand, int width, int height) {
        super(title, user, hand, width, height);
        this.BACKGROUND = new ResourceLocation("holdmetight", "textures/gui/size_remote_bg.png");
        this.range = 10;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.initButtons();
        this.initEditBoxes();
    }

    @Override
    public void m_88315_(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        graphics.m_280218_(this.BACKGROUND, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        this.renderPlayerDisplay(graphics, mouseX, mouseY, partialTicks);
        for (Renderable renderable : this.f_169369_) {
            renderable.m_88315_(graphics, mouseX, mouseY, partialTicks);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int p_94697_) {
        this.saveEditBox();
        return super.m_6375_(mouseX, mouseY, p_94697_);
    }

    protected void initButtons() {
        this.multButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)MULT_BUTTON, this::handleMultButton).m_252987_(this.leftPos + 8, this.bottomPos - 111, 76, 20).m_257505_(Tooltip.m_257550_((Component)MULT_BUTTON_TOOLTIP)).m_253136_());
        this.setButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)SET_BUTTON, this::handleSetButton).m_252987_(this.leftPos + 91, this.bottomPos - 111, 76, 20).m_257505_(Tooltip.m_257550_((Component)SET_BUTTON_TOOLTIP)).m_253136_());
        this.resetButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)RESET_BUTTON, this::handleResetButton).m_252987_(this.centerHorizonalPos - 38, this.bottomPos - 40, 76, 20).m_257505_(Tooltip.m_257550_((Component)RESET_BUTTON_TOOLTIP)).m_253136_());
    }

    protected void handleResetButton(Button button) {
        if (this.selectedEnt != null && this.inRange()) {
            float scale = 1.0f;
            if (this.tag.m_128471_("is player")) {
                scale = PlayerSizeProvider.getPlayerSizeCapability((Player)this.selectedEnt).getDefaultScale();
                PacketHandler.sendToServer(new SEntitySetTargetScalePacket(scale, this.selectedEnt.m_20148_(), this.tag.m_128451_("entity id"), 1, this.tag.m_128471_("is player")));
            } else {
                PacketHandler.sendToServer(new SEntitySetTargetScalePacket(scale, this.selectedEnt.m_20148_(), this.tag.m_128451_("entity id"), 20, this.tag.m_128471_("is player")));
            }
        }
    }

    protected void handleMultButton(Button button) {
        String scaleString = this.customScaleField.m_94155_();
        if (scaleString != null && !scaleString.isEmpty()) {
            Float scale = Float.valueOf(Float.parseFloat(scaleString));
            this.tag.m_128350_("multiplier", scale.floatValue());
            this.stack.m_41751_(this.tag);
        }
        if (this.selectedEnt != null && this.inRange()) {
            PacketHandler.sendToServer(new SEntityMultTargetScalePacket(this.tag.m_128457_("multiplier"), this.selectedEnt.m_20148_(), this.tag.m_128451_("entity id"), 20, this.tag.m_128471_("is player")));
        }
    }

    protected void handleSetButton(Button button) {
        String scaleString = this.customScaleField.m_94155_();
        if (scaleString != null && !scaleString.isEmpty()) {
            Float scale = Float.valueOf(Float.parseFloat(scaleString));
            this.tag.m_128350_("multiplier", scale.floatValue());
            this.stack.m_41751_(this.tag);
        }
        if (this.selectedEnt != null && this.inRange()) {
            PacketHandler.sendToServer(new SEntitySetTargetScalePacket(this.tag.m_128457_("multiplier"), this.selectedEnt.m_20148_(), this.tag.m_128451_("entity id"), 20, this.tag.m_128471_("is player")));
        }
    }

    protected void initEditBoxes() {
        this.customScaleField = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.leftPos + 48, this.bottomPos - 80, 80, 20, CUSTOM_SCALE_FIELD));
        Predicate<String> filter = new Predicate<String>(){

            @Override
            public boolean test(String t) {
                if (!t.trim().equals(t)) {
                    return false;
                }
                if (t != null && t.isEmpty()) {
                    return true;
                }
                String checkFinalChar = t.substring(t.length() - 1);
                if (checkFinalChar.equals("f") || checkFinalChar.equals("d")) {
                    return false;
                }
                try {
                    float f = Float.parseFloat(t);
                    return !(f < 0.0f);
                }
                catch (Exception e) {
                    return false;
                }
            }
        };
        this.customScaleField.m_94153_((Predicate)filter);
        Float mul = Float.valueOf(this.tag.m_128457_("multiplier"));
        String floatString = Float.toString(mul.floatValue());
        this.customScaleField.m_94144_(floatString);
        Tooltip t = Tooltip.m_257563_((Component)CUSTOM_SCALE_FIELD_TOOLTIP, (Component)CUSTOM_SCALE_FIELD_TOOLTIP);
        this.customScaleField.m_257544_(t);
    }

    public boolean m_7933_(int key, int p_96553_, int p_96554_) {
        if (key == 257) {
            this.saveEditBox();
        }
        return super.m_7933_(key, p_96553_, p_96554_);
    }

    @Override
    protected void saveEditBox() {
        String customScale = this.customScaleField.m_94155_();
        if (this.checkNotNull(customScale)) {
            Float scale = Float.valueOf(Float.parseFloat(customScale));
            this.tag.m_128350_("multiplier", scale.floatValue());
            this.stack.m_41751_(this.tag);
        }
    }

    protected boolean checkNotNull(String scale) {
        return scale != null && !scale.isEmpty();
    }
}

