/*
 * Decompiled with CFR 0.152.
 */
package com.ricardthegreat.holdmetight.items;

import com.mojang.datafixers.util.Pair;
import com.ricardthegreat.holdmetight.client.ClientHooks;
import com.ricardthegreat.holdmetight.items.CollarKeyItem;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.DistExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;
import top.theillusivec4.curios.common.inventory.CurioSlot;

public class CollarItem
extends Item
implements DyeableLeatherItem,
ICurioItem {
    public CollarItem(Item.Properties properties) {
        super(properties);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return super.initCapabilities(stack, nbt);
    }

    public int m_41121_(ItemStack stack) {
        CompoundTag tag = stack.m_41737_("display");
        return tag != null && tag.m_128425_("color", 99) ? tag.m_128451_("color") : MapColor.f_283913_.f_283871_;
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        List<MobEffectInstance> effects = this.getEffect(stack);
        for (int i = 0; i < effects.size(); ++i) {
            slotContext.entity().m_7292_(effects.get(i));
        }
        super.curioTick(slotContext, stack);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        if (stack.m_41737_("owners") == null && entity instanceof Player) {
            Player player = (Player)entity;
            this.setupNbt(stack, player);
        }
        super.m_6883_(stack, level, entity, slot, selected);
    }

    public boolean canUnequip(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.m_150110_().f_35937_) {
                return true;
            }
        }
        return !this.getIsLocked(stack);
    }

    public void m_7373_(ItemStack stack, @javax.annotation.Nullable Level level, List<Component> components, TooltipFlag flag) {
        boolean locked;
        super.m_7373_(stack, level, components, flag);
        Pair<UUID, String> owner = this.getFirstOwner(stack);
        if (owner != null) {
            components.add((Component)Component.m_237110_((String)"item.holdmetight.collar_item.owner", (Object[])new Object[]{owner.getSecond()}));
        }
        if (locked = this.getIsLocked(stack)) {
            components.add((Component)Component.m_237115_((String)"item.holdmetight.collar_item.locked").m_130940_(ChatFormatting.YELLOW));
        } else {
            components.add((Component)Component.m_237115_((String)"item.holdmetight.collar_item.unlocked").m_130940_(ChatFormatting.BLUE));
        }
    }

    public void m_7836_(ItemStack stack, Level level, Player player) {
        this.setupNbt(stack, player);
        super.m_7836_(stack, level, player);
    }

    public boolean m_142305_(ItemStack stack, ItemStack stack2, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (action == ClickAction.SECONDARY) {
            CollarKeyItem key;
            Pair<UUID, String> pair;
            if (!(slot instanceof CurioSlot)) {
                if (PotionUtils.m_43579_((ItemStack)stack2) != Potions.f_43598_) {
                    this.setEffect(stack, PotionUtils.m_43579_((ItemStack)stack2));
                    return true;
                }
                this.setLocked(stack);
                if (player.m_9236_().f_46443_) {
                    this.playSound(stack);
                }
                return true;
            }
            Item item = stack2.m_41720_();
            if (item instanceof CollarKeyItem && (pair = (key = (CollarKeyItem)item).getOwner(stack2)) != null && ((UUID)pair.getFirst()).compareTo((UUID)this.getFirstOwner(stack).getFirst()) == 0) {
                this.setLocked(stack);
                if (player.m_9236_().f_46443_) {
                    this.playSound(stack);
                }
                return true;
            }
        }
        return super.m_142305_(stack, stack, slot, action, player, access);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (level.m_5776_()) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientHooks.openCollarScreen(player, hand));
        }
        return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
    }

    public Pair<UUID, String> getFirstOwner(ItemStack stack) {
        CompoundTag tag = stack.m_41737_("owners");
        if (tag != null && tag.m_128441_("uuid0") && tag.m_128441_("name0")) {
            return new Pair((Object)tag.m_128342_("uuid0"), (Object)tag.m_128461_("name0"));
        }
        return null;
    }

    public List<Pair<UUID, String>> getOwners(ItemStack stack) {
        CompoundTag tag = stack.m_41737_("owners");
        ArrayList<Pair<UUID, String>> owners = new ArrayList<Pair<UUID, String>>();
        if (tag != null && tag.m_128441_("numOwners")) {
            for (int i = 0; i < tag.m_128451_("numOwners"); ++i) {
                owners.add((Pair<UUID, String>)new Pair((Object)tag.m_128342_("uuid" + i), (Object)tag.m_128461_("name" + i)));
            }
            return owners;
        }
        return null;
    }

    public void addOwner(ItemStack stack, @NotNull UUID uuid, @NotNull String name) {
        CompoundTag tag = stack.m_41698_("owners");
        tag.m_128362_("uuid" + tag.m_128451_("numOwners"), uuid);
        tag.m_128359_("name" + tag.m_128451_("numOwners"), name);
        tag.m_128405_("numOwners", tag.m_128451_("numOwners") + 1);
    }

    public void removeOwner(ItemStack stack, UUID uuid, String name) {
    }

    public boolean getIsLocked(ItemStack stack) {
        CompoundTag tag = stack.m_41698_("locked");
        return tag.m_128471_("isLocked");
    }

    public void setLocked(ItemStack stack) {
        CompoundTag tag;
        tag.m_128379_("isLocked", !(tag = stack.m_41698_("locked")).m_128471_("isLocked"));
    }

    public void setEffect(ItemStack stack, Potion potion) {
        stack.m_41749_("potion");
        CompoundTag tag = stack.m_41698_("potion");
        List effects = potion.m_43488_();
        tag.m_128405_("numEffects", effects.size());
        for (int i = 0; i < effects.size(); ++i) {
            tag.m_128405_("effectId" + i, MobEffect.m_19459_((MobEffect)((MobEffectInstance)effects.get(i)).m_19544_()));
        }
    }

    public List<MobEffectInstance> getEffect(ItemStack stack) {
        CompoundTag tag = stack.m_41698_("potion");
        ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
        for (int i = 0; i < tag.m_128451_("numEffects"); ++i) {
            effects.add(new MobEffectInstance(MobEffect.m_19453_((int)tag.m_128451_("effectId" + i)), 20));
        }
        return effects;
    }

    private void setupNbt(ItemStack stack, Player player) {
        CompoundTag tag = stack.m_41698_("locked");
        tag.m_128379_("isLocked", false);
        this.addOwner(stack, player.m_20148_(), player.m_7755_().getString());
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playSound(ItemStack stack) {
        if (this.getIsLocked(stack)) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12636_, (float)1.0f));
        } else {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
        }
    }
}

