/*
 * Decompiled with CFR 0.152.
 */
package com.ricardthegreat.holdmetight.items;

import com.mojang.datafixers.util.Pair;
import com.ricardthegreat.holdmetight.items.CollarItem;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class CollarKeyItem
extends Item {
    private InteractionResult interactResult;

    public CollarKeyItem(Item.Properties p_41383_) {
        super(p_41383_);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag flag) {
        super.m_7373_(stack, level, components, flag);
        Pair<UUID, String> owner = this.getOwner(stack);
        if (owner != null) {
            components.add((Component)Component.m_237110_((String)"item.holdmetight.collar_key_item.owner", (Object[])new Object[]{owner.getSecond()}));
        }
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity entity, InteractionHand hand) {
        if (entity instanceof Player) {
            Player target = (Player)entity;
            this.interactResult = InteractionResult.FAIL;
            CuriosApi.getCuriosInventory((LivingEntity)target).ifPresent(handler -> handler.getStacksHandler("collar").ifPresent(stacksHandler -> {
                IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    ItemStack collarStack = stackHandler.getStackInSlot(i);
                    Item patt2580$temp = collarStack.m_41720_();
                    if (!(patt2580$temp instanceof CollarItem)) continue;
                    CollarItem item = (CollarItem)patt2580$temp;
                    this.interactResult = this.unlockCollar(stack, collarStack);
                }
            }));
            return this.interactResult;
        }
        return super.m_6880_(stack, player, entity, hand);
    }

    public void m_7836_(ItemStack stack, Level level, Player player) {
        this.addOwner(stack, player.m_20148_(), player.m_7755_().getString());
        super.m_7836_(stack, level, player);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        CompoundTag tag = stack.m_41737_("owner");
        if (tag == null && entity instanceof Player) {
            Player player = (Player)entity;
            this.addOwner(stack, player.m_20148_(), player.m_7755_().getString());
        }
        super.m_6883_(stack, level, entity, slot, selected);
    }

    public Pair<UUID, String> getOwner(ItemStack stack) {
        CompoundTag tag = stack.m_41737_("owner");
        if (tag != null && tag.m_128441_("uuid") && tag.m_128441_("name")) {
            return new Pair((Object)tag.m_128342_("uuid"), (Object)tag.m_128461_("name"));
        }
        return null;
    }

    public void addOwner(ItemStack stack, @NotNull UUID uuid, @NotNull String name) {
        CompoundTag tag = stack.m_41698_("owner");
        tag.m_128362_("uuid", uuid);
        tag.m_128359_("name", name);
    }

    private InteractionResult unlockCollar(ItemStack key, ItemStack collarStack) {
        CollarItem collar = (CollarItem)collarStack.m_41720_();
        Pair<UUID, String> owner = collar.getFirstOwner(collarStack);
        if (owner != null && ((UUID)owner.getFirst()).compareTo((UUID)this.getOwner(key).getFirst()) == 0) {
            collar.setLocked(collarStack);
            if (Minecraft.m_91087_().f_91073_ != null && Minecraft.m_91087_().f_91073_.f_46443_) {
                this.playSound(collarStack);
            }
        }
        return InteractionResult.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playSound(ItemStack stack) {
        CollarItem collar = (CollarItem)stack.m_41720_();
        if (collar.getIsLocked(stack)) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12636_, (float)1.0f));
        } else {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
        }
    }
}

