/*
 * Decompiled with CFR 0.152.
 */
package com.ricardthegreat.holdmetight.items.remotes;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public abstract class AbstractSizeRemoteItem
extends Item {
    public static final String SCALE_TAG = "multiplier";
    public static final String UUID_TAG = "target";
    public static final String MIN_SCALE_TAG = "minscale";
    public static final String MAX_SCALE_TAG = "maxscale";
    public static final String NUM_TICKS_TAG = "numticks";
    public static final String TARGET_TAG = "has target";
    public static final String ENTITY_ID = "entity id";
    public static final String IS_PLAYER_TAG = "is player";
    public static final Float DEFAULT_SCALE = Float.valueOf(1.0f);
    public static final int DEFAULT_TICKS = 20;
    public static final float RANDOM_MAX_LIMIT = 100.0f;
    public static final float RANDOM_MIN_LIMIT = 0.0f;

    public AbstractSizeRemoteItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level level, @Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack item = player.m_21120_(hand);
        if (!item.m_41782_()) {
            this.setDefaultTags(item, player);
        }
        CompoundTag tag = item.m_41783_();
        if (player.m_6144_()) {
            tag.m_128362_(UUID_TAG, player.m_20148_());
            tag.m_128405_(ENTITY_ID, player.m_19879_());
            tag.m_128379_(IS_PLAYER_TAG, true);
            item.m_41751_(tag);
            return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
        }
        if (level.m_5776_()) {
            this.openScreen(player, hand);
        }
        return super.m_7203_(level, player, hand);
    }

    protected abstract void openScreen(Player var1, InteractionHand var2);

    protected CompoundTag setDefaultTags(ItemStack stack, Player player) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128350_(SCALE_TAG, DEFAULT_SCALE.floatValue());
        tag.m_128350_(MIN_SCALE_TAG, 0.5f);
        tag.m_128350_(MAX_SCALE_TAG, 2.0f);
        tag.m_128405_(NUM_TICKS_TAG, 20);
        tag.m_128362_(UUID_TAG, player.m_20148_());
        stack.m_41751_(tag);
        return tag;
    }

    public void m_6883_(@Nonnull ItemStack stack, @Nonnull Level level, @Nonnull Entity entity, int tick, boolean bool) {
    }

    public void m_7836_(@Nonnull ItemStack stack, @Nonnull Level level, @Nonnull Player player) {
        this.setDefaultTags(stack, player);
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> list, @Nonnull TooltipFlag flag) {
        CompoundTag tag = stack.m_41783_();
        MutableComponent target = Component.m_237115_((String)"tooltip.holdmetight.abstract_size_remote_target.tooltip");
        MutableComponent noTarget = Component.m_237115_((String)"tooltip.holdmetight.abstract_size_remote_no_target.tooltip");
        if (tag != null) {
            String tooltip = target.getString();
            if (level != null) {
                if (tag.m_128441_(TARGET_TAG) && !tag.m_128471_(TARGET_TAG)) {
                    list.add((Component)Component.m_237113_((String)noTarget.getString()));
                } else if (tag.m_128471_(IS_PLAYER_TAG)) {
                    Player player = level.m_46003_(tag.m_128342_(UUID_TAG));
                    if (player != null) {
                        list.add((Component)Component.m_237113_((String)(tooltip + player.m_7755_().getString())));
                    }
                } else {
                    Entity entity = level.m_6815_(tag.m_128451_(ENTITY_ID));
                    if (entity != null) {
                        list.add((Component)Component.m_237113_((String)(tooltip + entity.m_7755_().getString())));
                    }
                }
            }
        }
        super.m_7373_(stack, level, list, flag);
    }

    public InteractionResult m_6880_(@Nonnull ItemStack stack, @Nonnull Player player, @Nonnull LivingEntity entity, @Nonnull InteractionHand hand) {
        ItemStack item = player.m_21120_(hand);
        if (!item.m_41782_()) {
            this.setDefaultTags(item, player);
        }
        CompoundTag tag = item.m_41783_();
        if (player.m_36335_().m_41519_((Item)this)) {
            return InteractionResult.PASS;
        }
        if (entity instanceof Player) {
            tag.m_128362_(UUID_TAG, entity.m_20148_());
            tag.m_128405_(ENTITY_ID, entity.m_19879_());
            tag.m_128379_(IS_PLAYER_TAG, true);
            item.m_41751_(tag);
            player.m_36335_().m_41524_((Item)this, 20);
            return InteractionResult.SUCCESS;
        }
        tag.m_128362_(UUID_TAG, entity.m_20148_());
        tag.m_128405_(ENTITY_ID, entity.m_19879_());
        tag.m_128379_(IS_PLAYER_TAG, false);
        item.m_41751_(tag);
        player.m_36335_().m_41524_((Item)this, 20);
        return InteractionResult.SUCCESS;
    }
}

