/*
 * Decompiled with CFR 0.152.
 */
package com.ricardthegreat.holdmetight.mixins;

import com.ricardthegreat.holdmetight.carry.CarryPosition;
import com.ricardthegreat.holdmetight.carry.PlayerCarry;
import com.ricardthegreat.holdmetight.carry.PlayerCarryProvider;
import com.ricardthegreat.holdmetight.network.CPlayerDismountPlayerPacket;
import com.ricardthegreat.holdmetight.network.PacketHandler;
import com.ricardthegreat.holdmetight.utils.sizeutils.EntitySizeUtils;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    private double vertOffset = 0.0;
    private double xOffset = 0.0;
    private double yOffset = 0.0;

    @Inject(at={@At(value="HEAD")}, method={"interact(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;"}, cancellable=true)
    public void unnamedsizemod$interact(Player vehicle, InteractionHand hand, CallbackInfoReturnable<InteractionResult> info) {
        Entity rider = (Entity)this;
        PlayerCarry vehicleCarry = PlayerCarryProvider.getPlayerCarryCapability(vehicle);
        if (vehicleCarry.getIsCarrying()) {
            if (vehicle.m_20197_().size() == 0) {
                vehicleCarry.setCarrying(false);
            }
        } else if (rider instanceof Player && vehicle.m_21205_() == ItemStack.f_41583_ && EntitySizeUtils.getSize(rider) <= EntitySizeUtils.getSize((Entity)vehicle) / 4.0f) {
            PlayerCarry riderCarry = PlayerCarryProvider.getPlayerCarryCapability((Player)rider);
            rider.m_20329_((Entity)vehicle);
            riderCarry.setCarried(true);
            vehicleCarry.setCarrying(true);
            if (!rider.m_9236_().m_5776_()) {
                riderCarry.setShouldSyncSimple(true);
                vehicleCarry.setShouldSyncSimple(true);
            }
        } else if (!(rider instanceof Player) && vehicle.m_21205_() == ItemStack.f_41583_ && EntitySizeUtils.getSize(rider) <= EntitySizeUtils.getSize((Entity)vehicle) / 4.0f) {
            rider.m_20329_((Entity)vehicle);
            vehicleCarry.setCarrying(true);
            if (!rider.m_9236_().m_5776_()) {
                vehicleCarry.setShouldSyncSimple(true);
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"stopRiding()V"})
    public void unnamedsizemod$dismount(CallbackInfo info) {
        Entity ent = (Entity)this;
        Entity vehicle = ent.m_20202_();
        if (ent instanceof Player && ent.m_20159_() && vehicle != null && vehicle instanceof Player) {
            PlayerCarry vehicleCarry = PlayerCarryProvider.getPlayerCarryCapability((Player)vehicle);
            PlayerCarry riderCarry = PlayerCarryProvider.getPlayerCarryCapability((Player)ent);
            vehicleCarry.setCarrying(false);
            riderCarry.setCarried(false);
            if (!ent.m_9236_().m_5776_()) {
                vehicleCarry.setShouldSyncSimple(true);
                riderCarry.setShouldSyncSimple(true);
                PacketHandler.sendToAllClients(new CPlayerDismountPlayerPacket(ent.m_20148_()));
            }
        } else if (!(ent instanceof Player) && ent.m_20159_() && vehicle != null && vehicle instanceof Player) {
            PlayerCarry vehicleCarry = PlayerCarryProvider.getPlayerCarryCapability((Player)vehicle);
            vehicleCarry.setCarrying(false);
            if (!ent.m_9236_().m_5776_()) {
                vehicleCarry.setShouldSyncSimple(true);
            }
        }
    }

    @Overwrite
    protected void m_19956_(Entity rider, Entity.MoveFunction func) {
        Entity vehicle = (Entity)this;
        if (vehicle.m_20363_(rider)) {
            if (vehicle instanceof Player) {
                Player player = (Player)vehicle;
                double scaleDif = EntitySizeUtils.getSize(vehicle) / EntitySizeUtils.getSize(rider);
                PlayerCarry vehicleCarry = PlayerCarryProvider.getPlayerCarryCapability(player);
                if (scaleDif < 4.0) {
                    rider.m_8127_();
                } else if (vehicleCarry.getCarryPosition().headLink) {
                    this.calcHeadPosition(player, rider);
                    func.m_20372_(rider, vehicle.m_20185_() + this.xOffset, this.vertOffset, vehicle.m_20189_() + this.yOffset);
                } else {
                    this.calcBodyPosition(player, rider);
                    func.m_20372_(rider, vehicle.m_20185_() + this.xOffset, this.vertOffset, vehicle.m_20189_() + this.yOffset);
                }
            } else {
                this.vertOffset = vehicle.m_20186_() + vehicle.m_6048_() + rider.m_6049_();
                func.m_20372_(rider, vehicle.m_20185_(), this.vertOffset, vehicle.m_20189_());
            }
        }
    }

    private void calcBodyPosition(Player vehicle, Entity rider) {
        PlayerCarry vehicleCarry = PlayerCarryProvider.getPlayerCarryCapability(vehicle);
        CarryPosition carryPos = vehicleCarry.getCarryPosition();
        if (vehicle.m_21205_() != ItemStack.f_41583_ && carryPos.posName == "hand") {
            vehicleCarry.setCarryPosition(false, 1);
            if (!vehicle.m_9236_().f_46443_) {
                vehicleCarry.setShouldSyncSimple(true);
            }
        }
        this.vertOffset = vehicle.m_20186_() + vehicle.m_6048_() + rider.m_6049_() - carryPos.vertOffset * (double)EntitySizeUtils.getSize((Entity)vehicle);
        double degrees = vehicle.f_20884_ + (float)carryPos.RotationOffset;
        double rotation = Math.toRadians(degrees % 360.0);
        double leftRightOffset = Math.toRadians((degrees + 90.0) % 360.0);
        double x = Math.cos(leftRightOffset) * carryPos.leftRightMove;
        double y = Math.sin(leftRightOffset) * carryPos.leftRightMove;
        this.xOffset = Math.cos(rotation) * carryPos.xymult + x;
        this.yOffset = Math.sin(rotation) * carryPos.xymult + y;
        this.xOffset *= (double)EntitySizeUtils.getSize((Entity)vehicle);
        this.yOffset *= (double)EntitySizeUtils.getSize((Entity)vehicle);
    }

    private void calcHeadPosition(Player vehicle, Entity rider) {
        PlayerCarry vehicleCarry = PlayerCarryProvider.getPlayerCarryCapability(vehicle);
        CarryPosition carryPos = vehicleCarry.getCarryPosition();
        if (vehicle.m_21205_() != ItemStack.f_41583_ && carryPos.posName == "hand") {
            vehicleCarry.setCarryPosition(false, 1);
            if (!vehicle.m_9236_().f_46443_) {
                vehicleCarry.setShouldSyncSimple(true);
            }
        }
        Vec3 vec = vehicle.m_20154_();
        double offsetAddition = carryPos.vertOffset * (double)EntitySizeUtils.getSize((Entity)vehicle) * Math.abs(vec.f_82480_ - 1.0);
        this.vertOffset = vehicle.m_20186_() + vehicle.m_6048_() + rider.m_6049_() - offsetAddition;
        double degrees = vehicle.f_20886_ + (float)carryPos.RotationOffset;
        double leftRightOffset = Math.toRadians((degrees + 90.0) % 360.0);
        double x = Math.cos(leftRightOffset) * carryPos.leftRightMove;
        double y = Math.sin(leftRightOffset) * carryPos.leftRightMove;
        this.xOffset = vec.f_82479_ * carryPos.xymult + x;
        this.yOffset = vec.f_82481_ * carryPos.xymult + y;
        this.xOffset *= (double)EntitySizeUtils.getSize((Entity)vehicle);
        this.yOffset *= (double)EntitySizeUtils.getSize((Entity)vehicle);
    }

    @Inject(at={@At(value="HEAD")}, method={"push(Lnet/minecraft/world/entity/Entity;)V"}, cancellable=true)
    public void push(Entity entity, CallbackInfo info) {
        Entity thisEnt = (Entity)this;
        float scaleDif = EntitySizeUtils.getSize(entity) / EntitySizeUtils.getSize(thisEnt);
        if ((double)scaleDif <= 0.5 || scaleDif >= 2.0f) {
            info.cancel();
        }
    }

    @Overwrite
    public boolean m_5825_() {
        if (EntitySizeUtils.getSize((Entity)this) >= 4.0f) {
            return true;
        }
        return ((Entity)this).m_6095_().m_20672_();
    }
}

