/*
 * Decompiled with CFR 0.152.
 */
package com.ricardthegreat.holdmetight.mixins.climbing;

import com.ricardthegreat.holdmetight.utils.sizeutils.EntitySizeUtils;
import com.ricardthegreat.holdmetight.utils.sizeutils.PlayerSizeUtils;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public class EntityClimbingMixin {
    @Inject(at={@At(value="HEAD")}, method={"tick()V"}, cancellable=true)
    public void tick(CallbackInfo info) {
        Player player;
        double sizeDif;
        Entity ent = (Entity)this;
        if (ent instanceof Player && this.holdingClimbingItem((Player)ent) && (sizeDif = (double)(PlayerSizeUtils.getSize(player = (Player)ent) / EntitySizeUtils.getSize(ent))) <= 0.5) {
            this.shuntIfInsideHitbox((LivingEntity)player);
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"canBeCollidedWith()Z"}, cancellable=true)
    public void canBeCollidedWith(CallbackInfoReturnable<Boolean> info) {
    }

    @Inject(at={@At(value="RETURN")}, method={"canCollideWith(Lnet/minecraft/world/entity/Entity;)Z"}, cancellable=true)
    public void canCollideWith(Entity entity, CallbackInfoReturnable<Boolean> info) {
        Entity thisEnt = (Entity)this;
        if (thisEnt instanceof Player) {
            Player player = (Player)thisEnt;
            double sizeDif = PlayerSizeUtils.getSize(player) / EntitySizeUtils.getSize(entity);
            if (this.holdingClimbingItem(player) && sizeDif <= 0.5) {
                info.setReturnValue((Object)true);
            }
        }
    }

    private boolean holdingClimbingItem(Player player) {
        return player.m_21205_().m_150930_(Items.f_42518_) || player.m_21206_().m_150930_(Items.f_42518_);
    }

    private void shuntIfInsideHitbox(LivingEntity player) {
        List list = player.m_9236_().m_45933_((Entity)player, player.m_20191_());
        if (!list.isEmpty()) {
            for (Entity ent : list) {
                if (!player.m_20191_().m_82381_(ent.m_20191_())) continue;
                if (this.upperHalfHitbox(player, ent)) {
                    player.m_6034_(player.m_20182_().f_82479_, ent.m_20191_().f_82292_, player.m_20182_().f_82481_);
                    continue;
                }
                Vec3 centreDistance = player.m_20182_().m_82505_(ent.m_20182_());
                if (Math.abs(centreDistance.f_82479_) > Math.abs(centreDistance.f_82481_)) {
                    double x = this.findXPos(player, ent);
                    player.m_6034_(x, player.m_20182_().f_82480_, player.m_20182_().f_82481_);
                    continue;
                }
                double z = this.findZPos(player, ent);
                player.m_6034_(player.m_20182_().f_82479_, player.m_20182_().f_82480_, z);
            }
        }
    }

    private double findXPos(LivingEntity player, Entity ent) {
        double entXPos = ent.m_20182_().m_7096_();
        double playerXPos = player.m_20182_().m_7096_();
        AABB entBB = ent.m_20191_();
        AABB playerBB = player.m_20191_();
        if (playerXPos > entXPos) {
            return (entBB.f_82291_ + playerBB.f_82291_ - playerBB.f_82288_) / 2.0;
        }
        return entBB.f_82288_ - (playerBB.f_82291_ - playerBB.f_82288_) / 2.0;
    }

    private double findZPos(LivingEntity player, Entity ent) {
        double entZPos = ent.m_20182_().m_7094_();
        double playerZPos = player.m_20182_().m_7094_();
        AABB entBB = ent.m_20191_();
        AABB playerBB = player.m_20191_();
        if (playerZPos > entZPos) {
            return (entBB.f_82293_ + playerBB.f_82293_ - playerBB.f_82290_) / 2.0;
        }
        return entBB.f_82290_ - (playerBB.f_82293_ - playerBB.f_82290_) / 2.0;
    }

    private boolean upperHalfHitbox(LivingEntity player, Entity entity) {
        double half = (entity.m_20191_().f_82289_ + entity.m_20191_().f_82292_) / 2.0;
        return player.m_20182_().m_7098_() > half;
    }
}

