/*
 * Decompiled with CFR 0.152.
 */
package com.ricardthegreat.holdmetight.mixins.climbing;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.ricardthegreat.holdmetight.utils.sizeutils.EntitySizeUtils;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class EntityClimbingMixin2
extends Entity {
    @Shadow
    protected boolean f_20899_;
    @Shadow
    private Optional<BlockPos> f_20957_;
    private boolean onTop = false;

    public EntityClimbingMixin2(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    public void m_6478_(MoverType mover, Vec3 vec3) {
        LivingEntity ent = (LivingEntity)this;
        if (this.onTop && vec3.f_82480_ < 0.0) {
            this.m_183634_();
            if (ent instanceof Player && this.f_20899_) {
                Player player = (Player)ent;
                player.m_6135_();
            }
        }
        super.m_6478_(mover, vec3);
    }

    protected BlockPos m_20099_() {
        Player entity;
        List list;
        Entity ent = this;
        if (ent instanceof Player && !(list = (entity = (Player)ent).m_9236_().m_45933_((Entity)entity, entity.m_20191_().m_82363_(0.0, -1.0, 0.0))).isEmpty() && this.onTop((LivingEntity)entity, (Entity)list.get(0))) {
            return ((Entity)list.get(0)).m_20183_().m_7495_();
        }
        return super.m_20099_();
    }

    @Inject(at={@At(value="HEAD")}, method={"tick()V"}, cancellable=true)
    public void tick(CallbackInfo info) {
        LivingEntity ent = (LivingEntity)this;
        if (ent instanceof Player && this.holdingClimbingItem((Player)ent)) {
            Player player = (Player)ent;
            this.shuntIfInsideHitbox((LivingEntity)player);
            this.checkEntVertical(player);
        }
    }

    @ModifyReturnValue(method={"onClimbable()Z"}, at={@At(value="RETURN")})
    public boolean onClimbable(boolean original) {
        LivingEntity ent = (LivingEntity)this;
        if (original) {
            return original;
        }
        if (ent.m_5833_() || (double)EntitySizeUtils.getSize((Entity)ent) >= 0.8 || !(ent instanceof Player)) {
            return false;
        }
        if (this.checkForBlock(ent)) {
            this.f_20957_ = Optional.of(ent.m_20183_());
            return true;
        }
        return this.checkClimbableEnt(ent);
    }

    private boolean checkClimbableEnt(LivingEntity entity) {
        List list = entity.m_9236_().m_45933_((Entity)entity, entity.m_20191_().m_82377_(1.0, 0.0, 1.0));
        if (!list.isEmpty()) {
            for (Entity collison : list) {
                if (!this.touchSide(entity, collison)) continue;
                System.out.println(true);
                return true;
            }
        }
        return false;
    }

    private boolean touchSide(LivingEntity player, Entity ent) {
        AABB entBB = ent.m_20191_();
        AABB playerBB = player.m_20191_();
        boolean minX = entBB.f_82288_ == playerBB.f_82291_;
        boolean maxX = entBB.f_82291_ == playerBB.f_82288_;
        boolean minY = entBB.f_82289_ == playerBB.f_82292_;
        boolean maxY = entBB.f_82292_ == playerBB.f_82289_;
        return minX || maxX || minY || maxY;
    }

    private void shuntIfInsideHitbox(LivingEntity player) {
        List list = player.m_9236_().m_45933_((Entity)player, player.m_20191_());
        if (!list.isEmpty()) {
            for (Entity ent : list) {
                if (!player.m_20191_().m_82381_(ent.m_20191_())) continue;
                if (this.upperHalfHitbox(player, ent)) {
                    player.m_6034_(player.m_20182_().f_82479_, ent.m_20191_().f_82292_, player.m_20182_().f_82481_);
                    continue;
                }
                Vec3 centreDistance = player.m_20182_().m_82505_(ent.m_20182_());
                if (Math.abs(centreDistance.f_82479_) > Math.abs(centreDistance.f_82481_)) {
                    double x = this.findXPos(player, ent);
                    player.m_6034_(x, player.m_20182_().f_82480_, player.m_20182_().f_82481_);
                    continue;
                }
                double z = this.findZPos(player, ent);
                player.m_6034_(player.m_20182_().f_82479_, player.m_20182_().f_82480_, z);
            }
        }
    }

    private double findXPos(LivingEntity player, Entity ent) {
        double entXPos = ent.m_20182_().m_7096_();
        double playerXPos = player.m_20182_().m_7096_();
        AABB entBB = ent.m_20191_();
        AABB playerBB = player.m_20191_();
        if (playerXPos > entXPos) {
            return (entBB.f_82291_ + playerBB.f_82291_ - playerBB.f_82288_) / 2.0;
        }
        return entBB.f_82288_ - (playerBB.f_82291_ - playerBB.f_82288_) / 2.0;
    }

    private double findZPos(LivingEntity player, Entity ent) {
        double entZPos = ent.m_20182_().m_7094_();
        double playerZPos = player.m_20182_().m_7094_();
        AABB entBB = ent.m_20191_();
        AABB playerBB = player.m_20191_();
        if (playerZPos > entZPos) {
            return (entBB.f_82293_ + playerBB.f_82293_ - playerBB.f_82290_) / 2.0;
        }
        return entBB.f_82290_ - (playerBB.f_82293_ - playerBB.f_82290_) / 2.0;
    }

    private boolean upperHalfHitbox(LivingEntity player, Entity entity) {
        double half = (entity.m_20191_().f_82289_ + entity.m_20191_().f_82292_) / 2.0;
        return player.m_20182_().m_7098_() > half;
    }

    private void checkEntVertical(Player entity) {
        List list = entity.m_9236_().m_45933_((Entity)entity, entity.m_20191_().m_82363_(0.0, -1.0, 0.0));
        if (!list.isEmpty()) {
            if (this.onTop((LivingEntity)entity, (Entity)list.get(0))) {
                if (entity.m_20184_().f_82480_ < 0.0) {
                    entity.m_20334_(entity.m_20184_().f_82479_, 0.0, entity.m_20184_().f_82481_);
                }
                if (entity.m_20182_().f_82480_ < ((Entity)list.get((int)0)).m_20191_().f_82292_) {
                    entity.m_6034_(entity.m_20182_().f_82479_, ((Entity)list.get((int)0)).m_20191_().f_82292_, entity.m_20182_().f_82481_);
                }
                entity.m_6853_(true);
                entity.m_150110_().f_35935_ = false;
                entity.m_6885_();
                this.onTop = true;
                this.f_19862_ = true;
            } else {
                this.onTop = false;
            }
        } else {
            this.onTop = false;
        }
    }

    private boolean onTop(LivingEntity player, Entity ent) {
        AABB bb = ent.m_20191_();
        Vec3 pos = player.m_20182_();
        boolean inX = pos.f_82479_ >= bb.f_82288_ && pos.f_82479_ <= bb.f_82291_;
        boolean inZ = pos.f_82481_ >= bb.f_82290_ && pos.f_82481_ <= bb.f_82293_;
        boolean onY = pos.f_82480_ >= bb.f_82292_ - (double)(0.1f * EntitySizeUtils.getSize(ent)) && pos.f_82480_ <= bb.f_82292_;
        return inX && inZ && onY;
    }

    private boolean holdingClimbingItem(Player player) {
        return player.m_21205_().m_150930_(Items.f_42518_) || player.m_21206_().m_150930_(Items.f_42518_);
    }

    private boolean checkForBlock(LivingEntity ent) {
        double bbradius = ent.m_20205_() / 2.0f;
        double xpos = ent.m_20182_().f_82479_;
        double zpos = ent.m_20182_().f_82481_;
        BlockPos playerBlockPos = ent.m_20183_();
        int bpx = playerBlockPos.m_123341_();
        int bpy = playerBlockPos.m_123342_();
        int bpz = playerBlockPos.m_123343_();
        int bpsouth = (int)Math.floor(zpos + bbradius);
        int bpeast = (int)Math.floor(xpos + bbradius);
        int bpnorth = (int)Math.floor(zpos - bbradius * 1.01);
        int bpwest = (int)Math.floor(xpos - bbradius * 1.01);
        Vec3i[] vecs = new Vec3i[]{new Vec3i(bpeast, bpy, bpz), new Vec3i(bpwest, bpy, bpz), new Vec3i(bpx, bpy, bpsouth), new Vec3i(bpx, bpy, bpnorth)};
        Level level = ent.m_9236_();
        for (int i = 0; i < 4; ++i) {
            BlockState state = level.m_8055_(new BlockPos(vecs[i]));
            if (!this.tinyCanClimb(state, ent)) continue;
            return true;
        }
        return false;
    }

    private boolean tinyCanClimb(BlockState state, LivingEntity ent) {
        if (!ent.f_19862_) {
            return false;
        }
        if (ent.m_21205_().m_150930_(Items.f_42518_) || ent.m_21206_().m_150930_(Items.f_42518_)) {
            return true;
        }
        return state.m_204336_(BlockTags.f_144274_) || state.m_204336_(BlockTags.f_13029_) || state.m_204336_(BlockTags.f_13089_) || state.m_204336_(BlockTags.f_215838_);
    }
}

