/*
 * Decompiled with CFR 0.152.
 */
package com.ricardthegreat.holdmetight.mixins.collisions;

import com.ricardthegreat.holdmetight.utils.sizeutils.EntitySizeUtils;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={LeverBlock.class})
public class LeverBlockMixin
extends FaceAttachedHorizontalDirectionalBlock {
    private static final VoxelShape COLLISION_NORTH_AABB = Block.m_49796_((double)5.0, (double)4.0, (double)13.0, (double)11.0, (double)12.0, (double)16.0);
    private static final VoxelShape COLLISION_SOUTH_AABB = Block.m_49796_((double)5.0, (double)4.0, (double)0.0, (double)11.0, (double)12.0, (double)3.0);
    private static final VoxelShape COLLISION_WEST_AABB = Block.m_49796_((double)13.0, (double)4.0, (double)5.0, (double)16.0, (double)12.0, (double)11.0);
    private static final VoxelShape COLLISION_EAST_AABB = Block.m_49796_((double)0.0, (double)4.0, (double)5.0, (double)3.0, (double)12.0, (double)11.0);
    private static final VoxelShape COLLISION_UP_AABB_Z = Block.m_49796_((double)5.0, (double)0.0, (double)4.0, (double)11.0, (double)3.0, (double)12.0);
    private static final VoxelShape COLLISION_UP_AABB_X = Block.m_49796_((double)4.0, (double)0.0, (double)5.0, (double)12.0, (double)3.0, (double)11.0);
    private static final VoxelShape COLLISION_DOWN_AABB_Z = Block.m_49796_((double)5.0, (double)13.0, (double)4.0, (double)11.0, (double)16.0, (double)12.0);
    private static final VoxelShape COLLISION_DOWN_AABB_X = Block.m_49796_((double)4.0, (double)13.0, (double)5.0, (double)12.0, (double)16.0, (double)11.0);

    public LeverBlockMixin(BlockBehaviour.Properties p_53182_) {
        super(p_53182_);
    }

    public VoxelShape m_5939_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        EntityCollisionContext entContext;
        Entity ent;
        if (context instanceof EntityCollisionContext && (ent = (entContext = (EntityCollisionContext)context).m_193113_()) != null && (double)EntitySizeUtils.getSize(ent) < 0.21) {
            return this.getCollision(state, level, pos, context);
        }
        return Shapes.m_83040_();
    }

    private VoxelShape getCollision(BlockState p_54665_, BlockGetter p_54666_, BlockPos p_54667_, CollisionContext p_54668_) {
        switch ((AttachFace)p_54665_.m_61143_((Property)f_53179_)) {
            case FLOOR: {
                switch (((Direction)p_54665_.m_61143_((Property)f_54117_)).m_122434_()) {
                    case X: {
                        return COLLISION_UP_AABB_X;
                    }
                }
                return COLLISION_UP_AABB_Z;
            }
            case WALL: {
                switch ((Direction)p_54665_.m_61143_((Property)f_54117_)) {
                    case EAST: {
                        return COLLISION_EAST_AABB;
                    }
                    case WEST: {
                        return COLLISION_WEST_AABB;
                    }
                    case SOUTH: {
                        return COLLISION_SOUTH_AABB;
                    }
                }
                return COLLISION_NORTH_AABB;
            }
        }
        switch (((Direction)p_54665_.m_61143_((Property)f_54117_)).m_122434_()) {
            case X: {
                return COLLISION_DOWN_AABB_X;
            }
        }
        return COLLISION_DOWN_AABB_Z;
    }
}

