/*
 * Decompiled with CFR 0.152.
 */
package com.ricardthegreat.holdmetight.mixins.playerextensions;

import com.ricardthegreat.holdmetight.carry.PlayerCarryProvider;
import com.ricardthegreat.holdmetight.size.PlayerSizeProvider;
import com.ricardthegreat.holdmetight.utils.sizeutils.PlayerSizeUtils;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleTypes;
import virtuoel.pehkui.util.PehkuiEntityExtensions;

@Mixin(value={Player.class})
public abstract class PlayerCapabilityMixin {
    private float prevScale = 0.0f;

    @Inject(at={@At(value="TAIL")}, method={"tick()V"})
    private void tick(CallbackInfo info) {
        Player player = (Player)this;
        PehkuiEntityExtensions pEnt = (PehkuiEntityExtensions)player;
        ScaleData data = pEnt.pehkui_getScaleData(ScaleTypes.BASE);
        player.getCapability(PlayerSizeProvider.PLAYER_SIZE).ifPresent(scale -> scale.tick(player));
        player.getCapability(PlayerCarryProvider.PLAYER_CARRY).ifPresent(scale -> scale.tick(player));
        if (!player.m_9236_().m_5776_()) {
            if (data.getScale() != this.prevScale) {
                PlayerSizeUtils.setPeripheralScales(player);
            }
            this.prevScale = data.getScale();
        }
    }
}

