/*
 * Decompiled with CFR 0.152.
 */
package com.ricardthegreat.holdmetight.mixins.swimming;

import com.ricardthegreat.holdmetight.utils.IBlockSwimming;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.extensions.IForgeEntity;
import net.minecraftforge.fluids.FluidType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class BlockSwimmingMixin
implements IBlockSwimming,
IForgeEntity {
    @Shadow
    protected Object2DoubleMap<FluidType> forgeFluidTypeHeight;
    private boolean wasInBlock = false;
    private boolean isInBlock = false;

    @Inject(at={@At(value="HEAD")}, method={"tick()V"}, cancellable=true)
    public void tick(CallbackInfo info) {
        if (this.isInBlock) {
            this.isInBlock = false;
            this.wasInBlock = true;
        } else {
            this.wasInBlock = false;
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"isInWater()Z"}, cancellable=true)
    public void isInWater(CallbackInfoReturnable<Boolean> info) {
        if (this.wasInBlock) {
            info.setReturnValue((Object)true);
        }
    }

    @Override
    public boolean getInSwimmableBlock() {
        return this.wasInBlock;
    }

    @Override
    public void setIsInSwimmableBlock(boolean block) {
        this.isInBlock = block;
    }

    public final double getFluidTypeHeight(FluidType type) {
        if (this.wasInBlock) {
            return 1.0;
        }
        return this.forgeFluidTypeHeight.getDouble((Object)type);
    }
}

