/*
 * Decompiled with CFR 0.152.
 */
package com.ricardthegreat.holdmetight.mixins.swimming;

import com.ricardthegreat.holdmetight.utils.IBlockSwimming;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.extensions.IForgeEntity;
import net.minecraftforge.fluids.FluidType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={IForgeEntity.class})
public interface SwimmingMixin {
    @Overwrite(remap=false)
    default public boolean canStartSwimming() {
        if (!this.getEyeInFluidType().isAir() && this.canSwimInFluidType(this.getEyeInFluidType())) {
            return true;
        }
        if (this instanceof Player) {
            Entity ent = (Entity)this;
            IBlockSwimming swimming = (IBlockSwimming)ent;
            return swimming.getInSwimmableBlock();
        }
        return false;
    }

    @Overwrite(remap=false)
    default public boolean canSwimInFluidType(FluidType type) {
        return type.canSwim(this.self());
    }

    @Shadow
    public FluidType getEyeInFluidType();

    @Shadow
    public Entity self();
}

