/*
 * Decompiled with CFR 0.152.
 */
package com.ricardthegreat.holdmetight.network;

import com.ricardthegreat.holdmetight.utils.sizeutils.EntitySizeUtils;
import com.ricardthegreat.holdmetight.utils.sizeutils.PlayerSizeUtils;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class SEntityAddTargetScalePacket {
    private final float scale;
    private final UUID uuid;
    private final int numericId;
    private final boolean player;

    public SEntityAddTargetScalePacket(float scale, UUID uuid, int numericId, boolean player) {
        this.scale = scale;
        this.uuid = uuid;
        this.numericId = numericId;
        this.player = player;
    }

    public SEntityAddTargetScalePacket(FriendlyByteBuf buffer) {
        this(buffer.readFloat(), buffer.m_130259_(), buffer.readInt(), buffer.readBoolean());
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.scale);
        buffer.m_130077_(this.uuid);
        buffer.writeInt(this.numericId);
        buffer.writeBoolean(this.player);
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        ServerPlayer sender = context.get().getSender();
        if (this.player) {
            ServerPlayer target = sender.f_8924_.m_6846_().m_11259_(this.uuid);
            if (target != null) {
                PlayerSizeUtils.addSize((Player)target, Float.valueOf(this.scale));
            }
        } else {
            Entity target = sender.m_9236_().m_6815_(this.numericId);
            if (target != null && target.m_20148_().compareTo(this.uuid) == 0) {
                EntitySizeUtils.addSize(target, Float.valueOf(this.scale));
            }
        }
    }
}

