/*
 * Decompiled with CFR 0.152.
 */
package com.ricardthegreat.holdmetight.size;

import com.ricardthegreat.holdmetight.network.CPlayerSizeMixinSyncPacket;
import com.ricardthegreat.holdmetight.network.PacketHandler;
import com.ricardthegreat.holdmetight.network.SPlayerSizeMixinSyncPacket;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;

public class PlayerSize {
    private float maxScale = 50000.0f;
    private float minScale = 0.0f;
    private float defaultScale = 1.0f;
    private boolean shouldSync = false;

    public void tick(Player player) {
        if (this.shouldSync) {
            this.sync(player);
        }
    }

    private void sync(Player player) {
        this.shouldSync = false;
        if (player.m_9236_().f_46443_) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> PacketHandler.sendToServer(new SPlayerSizeMixinSyncPacket(this.maxScale, this.minScale, this.defaultScale, player.m_20148_())));
        } else if (!player.m_20194_().m_6982_()) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> PacketHandler.sendToAllClients(new CPlayerSizeMixinSyncPacket(this.maxScale, this.minScale, this.defaultScale, player.m_20148_())));
        } else {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> PacketHandler.sendToAllClients(new CPlayerSizeMixinSyncPacket(this.maxScale, this.minScale, this.defaultScale, player.m_20148_())));
        }
    }

    public void updateSyncables(float maxScale, float minScale, float defaultScale) {
        this.maxScale = maxScale;
        this.minScale = minScale;
        this.defaultScale = defaultScale;
    }

    public CPlayerSizeMixinSyncPacket getSyncPacket(Player player) {
        return new CPlayerSizeMixinSyncPacket(this.maxScale, this.minScale, this.defaultScale, player.m_20148_());
    }

    public float getMaxScale() {
        return this.maxScale;
    }

    public void setMaxScale(Float maxScale) {
        if (maxScale.floatValue() < this.minScale) {
            maxScale = Float.valueOf(this.minScale);
        }
        if (maxScale.floatValue() < this.defaultScale) {
            this.defaultScale = maxScale.floatValue();
        }
        this.maxScale = maxScale.floatValue();
    }

    public float getMinScale() {
        return this.minScale;
    }

    public void setMinScale(Float minScale) {
        if (minScale.floatValue() > this.maxScale) {
            minScale = Float.valueOf(this.maxScale);
        }
        if (minScale.floatValue() > this.defaultScale) {
            this.defaultScale = minScale.floatValue();
        }
        this.minScale = minScale.floatValue();
    }

    public float getDefaultScale() {
        return this.defaultScale;
    }

    public void setDefaultScale(Float defaultScale) {
        this.defaultScale = defaultScale.floatValue() > this.maxScale ? this.maxScale : (defaultScale.floatValue() < this.minScale ? this.minScale : defaultScale.floatValue());
    }

    public void updateShouldSync() {
        this.shouldSync = true;
    }

    public void copy(PlayerSize source) {
        this.maxScale = source.maxScale;
        this.minScale = source.minScale;
        this.defaultScale = source.defaultScale;
    }

    public void saveNBTData(CompoundTag tag) {
        tag.m_128350_("maxScale", this.maxScale);
        tag.m_128350_("minScale", this.minScale);
        tag.m_128350_("defaultScale", this.defaultScale);
    }

    public void loadNBTData(CompoundTag tag) {
        this.maxScale = tag.m_128457_("maxScale");
        this.minScale = tag.m_128457_("minScale");
        this.defaultScale = tag.m_128457_("defaultScale");
    }
}

