/*
 * Decompiled with CFR 0.152.
 */
package com.ricardthegreat.holdmetight.utils.sizeutils;

import com.ricardthegreat.holdmetight.Config;
import com.ricardthegreat.holdmetight.utils.sizeutils.PlayerSizeUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleType;
import virtuoel.pehkui.api.ScaleTypes;
import virtuoel.pehkui.util.PehkuiEntityExtensions;

public class EntitySizeUtils {
    private static final ScaleType base = ScaleTypes.BASE;
    private static final ScaleType hitbox_height = ScaleTypes.HITBOX_HEIGHT;
    private static final ScaleType hitbox_width = ScaleTypes.HITBOX_WIDTH;
    private static final ScaleType step_height = ScaleTypes.STEP_HEIGHT;
    private static float maxScale = (float)Config.maxHitboxScale;

    public static void setSize(Entity entity, float size, int ticks) {
        size = EntitySizeUtils.lockSizeCap(size).floatValue();
        if (entity instanceof Player) {
            PlayerSizeUtils.setSize((Player)entity, size, ticks);
        } else {
            if (ticks < 0) {
                ticks = 0;
            }
            EntitySizeUtils.checkMaxHitbox(entity, size, ticks);
            ScaleData data = EntitySizeUtils.getScaleData(entity);
            data.setScaleTickDelay(ticks);
            data.setTargetScale(size);
        }
    }

    public static void multSize(Entity entity, Float size, int ticks) {
        if (entity instanceof Player) {
            PlayerSizeUtils.multSize((Player)entity, size, ticks);
        } else {
            Float targetScale = Float.valueOf(EntitySizeUtils.getScaleData(entity).getTargetScale() * size.floatValue());
            EntitySizeUtils.setSize(entity, targetScale.floatValue(), ticks);
        }
    }

    public static void addSize(Entity entity, Float size) {
        if (entity instanceof Player) {
            PlayerSizeUtils.addSize((Player)entity, size);
        } else {
            ScaleData data = EntitySizeUtils.getScaleData(entity);
            Float currentScale = Float.valueOf(data.getScale());
            currentScale = EntitySizeUtils.lockSizeCap(currentScale.floatValue() + size.floatValue());
            data.setScale(currentScale.floatValue());
        }
    }

    public static float getSize(Entity entity) {
        if (entity instanceof Player) {
            return PlayerSizeUtils.getSize((Player)entity);
        }
        return EntitySizeUtils.getScaleData(entity).getScale();
    }

    public static float getTargetSize(Entity entity) {
        if (entity instanceof Player) {
            return PlayerSizeUtils.getSize((Player)entity);
        }
        return EntitySizeUtils.getScaleData(entity).getTargetScale();
    }

    private static ScaleData getScaleData(Entity entity) {
        PehkuiEntityExtensions pEnt = (PehkuiEntityExtensions)entity;
        ScaleData data = pEnt.pehkui_getScaleData(base);
        return data;
    }

    private static void checkMaxHitbox(Entity entity, float size, int ticks) {
        PehkuiEntityExtensions pEnt = (PehkuiEntityExtensions)entity;
        ScaleData heightData = pEnt.pehkui_getScaleData(hitbox_height);
        ScaleData widthData = pEnt.pehkui_getScaleData(hitbox_width);
        heightData.setScaleTickDelay(ticks);
        widthData.setScaleTickDelay(ticks);
        if (size > maxScale) {
            heightData.setTargetScale(maxScale / size);
            widthData.setTargetScale(maxScale / size);
        } else if (heightData.getTargetScale() < 1.0f || widthData.getTargetScale() < 1.0f) {
            heightData.setTargetScale(1.0f);
            widthData.setTargetScale(1.0f);
        }
    }

    private static void fixStepHeight(PehkuiEntityExtensions pEnt, float size, int ticks) {
        ScaleData stepData = pEnt.pehkui_getScaleData(step_height);
        float stepHeight = (1.0f + (size - 1.0f) / 2.0f) / size;
        if (ticks > 0) {
            stepData.setScaleTickDelay(ticks);
            stepData.setTargetScale(stepHeight);
        } else {
            stepData.setScale(stepHeight);
        }
    }

    private static Float lockSizeCap(float size) {
        if ((double)size > Config.maxEntityScale) {
            return Float.valueOf((float)Config.maxEntityScale);
        }
        return Float.valueOf(size);
    }
}

