/*
 * Decompiled with CFR 0.152.
 */
package com.ricardthegreat.holdmetight.utils.sizeutils;

import com.ricardthegreat.holdmetight.Config;
import com.ricardthegreat.holdmetight.size.PlayerSize;
import com.ricardthegreat.holdmetight.size.PlayerSizeProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.LazyOptional;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleType;
import virtuoel.pehkui.api.ScaleTypes;
import virtuoel.pehkui.util.PehkuiEntityExtensions;

public class PlayerSizeUtils {
    private static ScaleType base = ScaleTypes.BASE;

    public static void setSize(Player player, float size, int ticks) {
        size = PlayerSizeUtils.clampToPreferences(player, size);
        size = PlayerSizeUtils.lockSizeCap(size).floatValue();
        System.out.println(size);
        ScaleData data = PlayerSizeUtils.getScaleData(player);
        if (ticks >= 0) {
            if (ticks == 0) {
                float mult = size / data.getScale();
                float prevTargScale = data.getTargetScale();
                data.setScale(size);
                data.setTargetScale(prevTargScale * mult);
            } else {
                data.setScaleTickDelay(ticks);
                data.setTargetScale(size);
            }
        }
    }

    public static void multSize(Player player, Float size, int ticks) {
        ScaleData data = PlayerSizeUtils.getScaleData(player);
        Float targetScale = Float.valueOf(data.getTargetScale() * size.floatValue());
        PlayerSizeUtils.setSize(player, targetScale.floatValue(), ticks);
    }

    public static void perpetualSize(Player player, Float size, int ticks) {
    }

    public static void addSize(Player player, Float size) {
        ScaleData data = PlayerSizeUtils.getScaleData(player);
        Float currentScale = Float.valueOf(data.getScale());
        Float targetScale = Float.valueOf(data.getTargetScale());
        currentScale = PlayerSizeUtils.lockSizeCap(currentScale.floatValue() + size.floatValue());
        targetScale = PlayerSizeUtils.lockSizeCap(targetScale.floatValue() + size.floatValue());
        data.setScale(currentScale.floatValue());
        data.setTargetScale(targetScale.floatValue());
    }

    public static float getSize(Player player) {
        return PlayerSizeUtils.getScaleData(player).getScale();
    }

    public static int getRemainingTicks(Player player) {
        float initial;
        float lastTarget = PlayerSizeUtils.getScaleData(player).getTargetScale();
        int remaining = lastTarget == (initial = PlayerSizeUtils.getScaleData(player).getInitialScale()) ? 0 : Math.round((float)PlayerSizeUtils.getScaleData(player).getScaleTickDelay() * ((lastTarget - PlayerSizeUtils.getScaleData(player).getBaseScale()) / (lastTarget - initial)));
        return remaining;
    }

    public static float getTargetSize(Player player) {
        return PlayerSizeUtils.getScaleData(player).getTargetScale();
    }

    private static ScaleData getScaleData(Player player) {
        PehkuiEntityExtensions pEnt = (PehkuiEntityExtensions)player;
        ScaleData data = pEnt.pehkui_getScaleData(base);
        return data;
    }

    private static Float lockSizeCap(float size) {
        return Float.valueOf((float)Math.min((double)size, Config.maxEntityScale));
    }

    public static void setPeripheralScales(Player player) {
        float currentScale = PlayerSizeUtils.getScaleData(player).getScale();
        PlayerSizeUtils.clampMaxHitbox(player, currentScale);
        PlayerSizeUtils.fixStepHeight(player, currentScale);
        PlayerSizeUtils.setFallDamage(player, currentScale);
        if (Config.miningSpeedScaleLink) {
            PlayerSizeUtils.setMiningSpeed(player, currentScale);
        }
        if (Config.damageTakenScaleLink) {
            PlayerSizeUtils.setDefence(player, currentScale);
        }
    }

    private static void clampMaxHitbox(Player player, float currentScale) {
        PehkuiEntityExtensions pEnt = (PehkuiEntityExtensions)player;
        ScaleData heightData = pEnt.pehkui_getScaleData(ScaleTypes.HITBOX_HEIGHT);
        ScaleData widthData = pEnt.pehkui_getScaleData(ScaleTypes.HITBOX_WIDTH);
        float maxHitboxScale = (float)Config.maxHitboxScale;
        if (currentScale > maxHitboxScale) {
            heightData.setScale(maxHitboxScale / currentScale);
            widthData.setScale(maxHitboxScale / currentScale);
        } else if (heightData.getTargetScale() < 1.0f || widthData.getTargetScale() < 1.0f) {
            heightData.setScale(1.0f);
            widthData.setScale(1.0f);
        }
    }

    private static void setFallDamage(Player player, float currentScale) {
        PehkuiEntityExtensions pEnt = (PehkuiEntityExtensions)player;
        ScaleData fallData = pEnt.pehkui_getScaleData(ScaleTypes.FALLING);
        if (currentScale < 1.0f) {
            fallData.setScale(currentScale);
        } else if (fallData.getScale() < 1.0f) {
            fallData.setScale(1.0f);
        }
    }

    private static void setDefence(Player player, float currentScale) {
        PehkuiEntityExtensions pEnt = (PehkuiEntityExtensions)player;
        ScaleData defenceData = pEnt.pehkui_getScaleData(ScaleTypes.DEFENSE);
        defenceData.setScale((float)Math.sqrt(currentScale));
    }

    private static void setMiningSpeed(Player player, float currentScale) {
        PehkuiEntityExtensions pEnt = (PehkuiEntityExtensions)player;
        ScaleData miningData = pEnt.pehkui_getScaleData(ScaleTypes.MINING_SPEED);
        miningData.setScale(currentScale);
    }

    private static void fixStepHeight(Player player, float currentScale) {
        PehkuiEntityExtensions pEnt = (PehkuiEntityExtensions)player;
        ScaleData stepData = pEnt.pehkui_getScaleData(ScaleTypes.STEP_HEIGHT);
        float stepHeight = (float)(1.0 / Math.sqrt(currentScale));
        stepData.setScale(stepHeight);
    }

    private static float clampToPreferences(Player player, float size) {
        LazyOptional optional = player.getCapability(PlayerSizeProvider.PLAYER_SIZE);
        PlayerSize orElse = (PlayerSize)optional.orElse(null);
        if (orElse != null) {
            size = Math.max(size, orElse.getMinScale());
            size = Math.min(size, orElse.getMaxScale());
        }
        return size;
    }
}

