/*
 * Decompiled with CFR 0.152.
 */
package com.ricardthegreat.holdmetight.Client.handlers;

import com.ricardthegreat.holdmetight.HoldMeTight;
import com.ricardthegreat.holdmetight.carry.PlayerCarry;
import com.ricardthegreat.holdmetight.carry.PlayerCarryProvider;
import com.ricardthegreat.holdmetight.network.CPlayerCarrySyncPacket;
import com.ricardthegreat.holdmetight.network.CPlayerDismountPlayerPacket;
import com.ricardthegreat.holdmetight.network.CPlayerSizeMixinSyncPacket;
import com.ricardthegreat.holdmetight.size.PlayerSize;
import com.ricardthegreat.holdmetight.size.PlayerSizeProvider;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.NetworkEvent;

public class ClientPacketHandler {
    public static void handleDismountPacket(CPlayerDismountPlayerPacket msg, Supplier<NetworkEvent.Context> context) {
        Player player;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null && (player = level.m_46003_(msg.getUuid())) != null) {
            player.m_8127_();
            HoldMeTight.LOGGER.info("ClientPacketHandler 23: " + player.m_20182_());
        }
    }

    public static void handleCarryPacket(CPlayerCarrySyncPacket msg, Supplier<NetworkEvent.Context> context) {
        Player player;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null && (player = level.m_46003_(msg.getUuid())) != null) {
            PlayerCarry playerCarry = PlayerCarryProvider.getPlayerCarryCapability(player);
            msg.playerSyncablesUpdate(playerCarry);
        }
    }

    public static void handleSizePacket(CPlayerSizeMixinSyncPacket msg, Supplier<NetworkEvent.Context> context) {
        Player player;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null && (player = level.m_46003_(msg.getUuid())) != null) {
            LazyOptional optional = player.getCapability(PlayerSizeProvider.PLAYER_SIZE);
            PlayerSize orElse = (PlayerSize)optional.orElse((Object)new PlayerSize());
            msg.playerSyncablesUpdate(orElse);
        }
    }

    public static void handleCarryPositionPacket(boolean carried, boolean carrying, int[] carryPos, UUID uuid, Supplier<NetworkEvent.Context> context) {
        Player player;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null && (player = level.m_46003_(uuid)) != null) {
            PlayerCarry playerCarry = PlayerCarryProvider.getPlayerCarryCapability(player);
            playerCarry.updateSimpleSyncables(carried, carrying, carryPos);
        }
    }
}

